/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonArray;
import com.dimensionrogue.libs.bson.BsonBoolean;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonInt32;
import com.dimensionrogue.libs.bson.BsonInt64;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.ReadConcern;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.WriteConcern;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.Collation;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.AsyncReadBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.ReadBinding;
import com.dimensionrogue.libs.mongodb.internal.client.model.AggregationLevel;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.ReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.SyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteConcernHelper;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AggregateToCollectionOperation
implements AsyncReadOperation<Void>,
ReadOperation<Void> {
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;

    public AggregateToCollectionOperation(MongoNamespace namespace, List<BsonDocument> pipeline) {
        this(namespace, pipeline, null, null, AggregationLevel.COLLECTION);
    }

    public AggregateToCollectionOperation(MongoNamespace namespace, List<BsonDocument> pipeline, WriteConcern writeConcern) {
        this(namespace, pipeline, null, writeConcern, AggregationLevel.COLLECTION);
    }

    public AggregateToCollectionOperation(MongoNamespace namespace, List<BsonDocument> pipeline, ReadConcern readConcern) {
        this(namespace, pipeline, readConcern, null, AggregationLevel.COLLECTION);
    }

    public AggregateToCollectionOperation(MongoNamespace namespace, List<BsonDocument> pipeline, ReadConcern readConcern, WriteConcern writeConcern) {
        this(namespace, pipeline, readConcern, writeConcern, AggregationLevel.COLLECTION);
    }

    public AggregateToCollectionOperation(MongoNamespace namespace, List<BsonDocument> pipeline, @Nullable ReadConcern readConcern, @Nullable WriteConcern writeConcern, AggregationLevel aggregationLevel) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.writeConcern = writeConcern;
        this.readConcern = readConcern;
        this.aggregationLevel = Assertions.notNull("aggregationLevel", aggregationLevel);
        Assertions.isTrueArgument("pipeline is not empty", !pipeline.isEmpty());
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregateToCollectionOperation allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public AggregateToCollectionOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public AggregateToCollectionOperation bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public AggregateToCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public AggregateToCollectionOperation let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    public AggregateToCollectionOperation comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public AggregateToCollectionOperation hint(@Nullable BsonValue hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public Void execute(ReadBinding binding) {
        return SyncOperationHelper.executeRetryableRead(binding, () -> binding.getReadConnectionSource(12, ReadPreference.primary()), this.namespace.getDatabaseName(), (serverDescription, connectionDescription) -> this.getCommand(), new BsonDocumentCodec(), (result, source, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        }, false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, connectionSourceCallback -> binding.getReadConnectionSource(12, ReadPreference.primary(), connectionSourceCallback), this.namespace.getDatabaseName(), (serverDescription, connectionDescription) -> this.getCommand(), new BsonDocumentCodec(), (result, source, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        }, false, callback);
    }

    private BsonDocument getCommand() {
        BsonValue aggregationTarget = this.aggregationLevel == AggregationLevel.DATABASE ? new BsonInt32(1) : new BsonString(this.namespace.getCollectionName());
        BsonDocument commandDocument = new BsonDocument("aggregate", aggregationTarget);
        commandDocument.put("pipeline", new BsonArray(this.pipeline));
        if (this.maxTimeMS > 0L) {
            commandDocument.put("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        if (this.bypassDocumentValidation != null) {
            commandDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
        }
        commandDocument.put("cursor", new BsonDocument());
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        if (this.readConcern != null && !this.readConcern.isServerDefault()) {
            commandDocument.put("readConcern", this.readConcern.asDocument());
        }
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        if (this.comment != null) {
            commandDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            commandDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            commandDocument.put("let", this.variables);
        }
        return commandDocument;
    }
}

