/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.inject;

import com.dimensionrogue.libs.mongodb.annotations.ThreadSafe;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.internal.inject.Provider;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public final class SameObjectProvider<T>
implements Provider<T> {
    private final AtomicReference<T> object = new AtomicReference();

    private SameObjectProvider(@Nullable T o) {
        if (o != null) {
            this.initialize(o);
        }
    }

    @Override
    public T get() {
        return Assertions.assertNotNull(this.object.get());
    }

    @Override
    public Optional<T> optional() {
        return Optional.of(this.get());
    }

    public void initialize(T o) {
        Assertions.assertTrue(this.object.compareAndSet(null, o));
    }

    public static <T> SameObjectProvider<T> initialized(T o) {
        return new SameObjectProvider<T>(o);
    }

    public static <T> SameObjectProvider<T> uninitialized() {
        return new SameObjectProvider<Object>(null);
    }
}

