/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.dns;

import com.dimensionrogue.libs.mongodb.MongoConfigurationException;
import com.dimensionrogue.libs.mongodb.internal.dns.DnsResolver;
import com.dimensionrogue.libs.mongodb.internal.dns.JndiDnsClient;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import com.dimensionrogue.libs.mongodb.spi.dns.DnsClient;
import com.dimensionrogue.libs.mongodb.spi.dns.DnsClientProvider;
import com.dimensionrogue.libs.mongodb.spi.dns.DnsWithResponseCodeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public final class DefaultDnsResolver
implements DnsResolver {
    private static final DnsClient DEFAULT_DNS_CLIENT = StreamSupport.stream(ServiceLoader.load(DnsClientProvider.class).spliterator(), false).findFirst().map(DnsClientProvider::create).orElse(new JndiDnsClient());
    private final DnsClient dnsClient;

    public DefaultDnsResolver() {
        this(DEFAULT_DNS_CLIENT);
    }

    public DefaultDnsResolver(@Nullable DnsClient dnsClient) {
        this.dnsClient = dnsClient == null ? DEFAULT_DNS_CLIENT : dnsClient;
    }

    @Override
    public List<String> resolveHostFromSrvRecords(String srvHost, String srvServiceName) {
        String srvHostDomain = srvHost.substring(srvHost.indexOf(46) + 1);
        List<String> srvHostDomainParts = Arrays.asList(srvHostDomain.split("\\."));
        ArrayList<String> hosts = new ArrayList<String>();
        String resourceName = "_" + srvServiceName + "._tcp." + srvHost;
        try {
            List<String> srvAttributeValues = this.dnsClient.getResourceRecordData(resourceName, "SRV");
            if (srvAttributeValues == null || srvAttributeValues.isEmpty()) {
                throw new MongoConfigurationException(String.format("No SRV records available for '%s'.", resourceName));
            }
            for (String srvRecord : srvAttributeValues) {
                String[] split = srvRecord.split(" ");
                String resolvedHost = split[3].endsWith(".") ? split[3].substring(0, split[3].length() - 1) : split[3];
                String resolvedHostDomain = resolvedHost.substring(resolvedHost.indexOf(46) + 1);
                if (!DefaultDnsResolver.sameParentDomain(srvHostDomainParts, resolvedHostDomain)) {
                    throw new MongoConfigurationException(String.format("The SRV host name '%s' resolved to a host '%s 'that is not in a sub-domain of the SRV host.", srvHost, resolvedHost));
                }
                hosts.add(resolvedHost + ":" + split[2]);
            }
        }
        catch (Exception e) {
            throw new MongoConfigurationException(String.format("Failed looking up SRV record for '%s'.", resourceName), e);
        }
        return hosts;
    }

    private static boolean sameParentDomain(List<String> srvHostDomainParts, String resolvedHostDomain) {
        List<String> resolvedHostDomainParts = Arrays.asList(resolvedHostDomain.split("\\."));
        if (srvHostDomainParts.size() > resolvedHostDomainParts.size()) {
            return false;
        }
        return resolvedHostDomainParts.subList(resolvedHostDomainParts.size() - srvHostDomainParts.size(), resolvedHostDomainParts.size()).equals(srvHostDomainParts);
    }

    @Override
    public String resolveAdditionalQueryParametersFromTxtRecords(String host) {
        try {
            List<String> attributeValues = this.dnsClient.getResourceRecordData(host, "TXT");
            if (attributeValues == null || attributeValues.isEmpty()) {
                return "";
            }
            if (attributeValues.size() > 1) {
                throw new MongoConfigurationException(String.format("Multiple TXT records found for host '%s'.  Only one is permitted", host));
            }
            return attributeValues.get(0).replaceAll("\\s", "");
        }
        catch (DnsWithResponseCodeException e) {
            if (e.getResponseCode() != 3) {
                throw new MongoConfigurationException("Failed looking up TXT record for host " + host, e);
            }
            return "";
        }
        catch (Exception e) {
            throw new MongoConfigurationException("Failed looking up TXT record for host " + host, e);
        }
    }
}

