/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.MongoClientException;
import com.dimensionrogue.libs.mongodb.MongoClientSettings;
import com.dimensionrogue.libs.mongodb.connection.NettyTransportSettings;
import com.dimensionrogue.libs.mongodb.connection.StreamFactoryFactory;
import com.dimensionrogue.libs.mongodb.connection.TransportSettings;
import com.dimensionrogue.libs.mongodb.connection.netty.NettyStreamFactoryFactory;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

public final class StreamFactoryHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static StreamFactoryFactory getStreamFactoryFactoryFromSettings(MongoClientSettings settings) {
        TransportSettings transportSettings = settings.getTransportSettings();
        if (transportSettings == null) return settings.getStreamFactoryFactory();
        if (!(transportSettings instanceof NettyTransportSettings)) throw new MongoClientException("Unsupported transport settings: " + transportSettings.getClass().getName());
        return NettyStreamFactoryFactory.builder().applySettings((NettyTransportSettings)transportSettings).build();
    }

    private StreamFactoryHelper() {
    }
}

