/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.MongoCommandException;
import com.dimensionrogue.libs.mongodb.MongoNodeIsRecoveringException;
import com.dimensionrogue.libs.mongodb.MongoNotPrimaryException;
import com.dimensionrogue.libs.mongodb.MongoSecurityException;
import com.dimensionrogue.libs.mongodb.MongoSocketException;
import com.dimensionrogue.libs.mongodb.MongoSocketReadTimeoutException;
import com.dimensionrogue.libs.mongodb.annotations.Immutable;
import com.dimensionrogue.libs.mongodb.annotations.ThreadSafe;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ServerDescription;
import com.dimensionrogue.libs.mongodb.connection.ServerId;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterableServer;
import com.dimensionrogue.libs.mongodb.internal.connection.ConnectionPool;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnection;
import com.dimensionrogue.libs.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.dimensionrogue.libs.mongodb.internal.connection.ServerDescriptionHelper;
import com.dimensionrogue.libs.mongodb.internal.connection.TopologyVersionHelper;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.Optional;

@ThreadSafe
interface SdamServerDescriptionManager {
    public void update(ServerDescription var1);

    public void handleExceptionBeforeHandshake(SdamIssue var1);

    public void handleExceptionAfterHandshake(SdamIssue var1);

    public SdamIssue.Context context();

    public SdamIssue.Context context(InternalConnection var1);

    @ThreadSafe
    public static final class SdamIssue {
        @Nullable
        private final Throwable exception;
        private final Context context;

        private SdamIssue(@Nullable Throwable exception, Context context) {
            this.exception = exception;
            this.context = Assertions.assertNotNull(context);
        }

        static SdamIssue specific(Throwable exception, Context context) {
            return new SdamIssue(Assertions.assertNotNull(exception), Assertions.assertNotNull(context));
        }

        static SdamIssue unspecified(Context context) {
            return new SdamIssue(null, Assertions.assertNotNull(context));
        }

        Optional<Throwable> exception() {
            return Optional.ofNullable(this.exception);
        }

        boolean specific() {
            return this.exception != null;
        }

        ServerDescription serverDescription() {
            return ServerDescriptionHelper.unknownConnectingServerDescription(this.context.serverId(), this.exception);
        }

        boolean serverIsLessThanVersionFourDotTwo() {
            return this.context.serverIsLessThanVersionFourDotTwo();
        }

        boolean stale(ConnectionPool connectionPool, ServerDescription currentServerDescription) {
            return this.context.stale(connectionPool) || SdamIssue.stale(this.exception, currentServerDescription);
        }

        boolean relatedToStateChange() {
            return this.exception instanceof MongoNotPrimaryException || this.exception instanceof MongoNodeIsRecoveringException;
        }

        boolean relatedToShutdown() {
            Assertions.assertTrue(this.relatedToStateChange());
            if (this.exception instanceof MongoCommandException) {
                return ClusterableServer.SHUTDOWN_CODES.contains(((MongoCommandException)this.exception).getErrorCode());
            }
            return false;
        }

        boolean relatedToNetworkTimeout() {
            return this.exception instanceof MongoSocketReadTimeoutException;
        }

        boolean relatedToNetworkNotTimeout() {
            return this.exception instanceof MongoSocketException && !this.relatedToNetworkTimeout();
        }

        boolean relatedToAuth() {
            return this.exception instanceof MongoSecurityException;
        }

        boolean relatedToWriteConcern() {
            return this.exception instanceof MongoWriteConcernWithResponseException;
        }

        private static boolean stale(@Nullable Throwable t, ServerDescription currentServerDescription) {
            return TopologyVersionHelper.topologyVersion(t).map(candidateTopologyVersion -> TopologyVersionHelper.newerOrEqual(currentServerDescription.getTopologyVersion(), candidateTopologyVersion)).orElse(false);
        }

        @Immutable
        static final class Context {
            private final ServerId serverId;
            private final int connectionPoolGeneration;
            private final int serverMaxWireVersion;

            Context(ServerId serverId, int connectionPoolGeneration, int serverMaxWireVersion) {
                this.serverId = Assertions.assertNotNull(serverId);
                this.connectionPoolGeneration = connectionPoolGeneration;
                this.serverMaxWireVersion = serverMaxWireVersion;
            }

            private boolean serverIsLessThanVersionFourDotTwo() {
                return this.serverMaxWireVersion < 8;
            }

            private boolean stale(ConnectionPool connectionPool) {
                return this.connectionPoolGeneration < connectionPool.getGeneration();
            }

            private ServerId serverId() {
                return this.serverId;
            }
        }
    }
}

