/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.bson.BsonBinaryWriter;
import com.dimensionrogue.libs.bson.BsonBinaryWriterSettings;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonElement;
import com.dimensionrogue.libs.bson.BsonWriter;
import com.dimensionrogue.libs.bson.BsonWriterSettings;
import com.dimensionrogue.libs.bson.FieldNameValidator;
import com.dimensionrogue.libs.bson.codecs.BsonValueCodecProvider;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.Encoder;
import com.dimensionrogue.libs.bson.codecs.EncoderContext;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistries;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.io.BsonOutput;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.internal.connection.ElementExtendingBsonWriter;
import com.dimensionrogue.libs.mongodb.internal.connection.MessageSettings;
import com.dimensionrogue.libs.mongodb.internal.connection.OpCode;
import com.dimensionrogue.libs.mongodb.internal.session.SessionContext;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

abstract class RequestMessage {
    static final AtomicInteger REQUEST_ID = new AtomicInteger(1);
    static final int MESSAGE_PROLOGUE_LENGTH = 16;
    private static final int DOCUMENT_HEADROOM = 16384;
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private final String collectionName;
    private final MessageSettings settings;
    private final int id;
    private final OpCode opCode;
    private EncodingMetadata encodingMetadata;

    public static int getCurrentGlobalId() {
        return REQUEST_ID.get();
    }

    RequestMessage(OpCode opCode, int requestId, MessageSettings settings) {
        this(null, opCode, requestId, settings);
    }

    RequestMessage(String collectionName, OpCode opCode, MessageSettings settings) {
        this(collectionName, opCode, REQUEST_ID.getAndIncrement(), settings);
    }

    private RequestMessage(@Nullable String collectionName, OpCode opCode, int requestId, MessageSettings settings) {
        this.collectionName = collectionName;
        this.settings = settings;
        this.id = requestId;
        this.opCode = opCode;
    }

    public int getId() {
        return this.id;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public MessageSettings getSettings() {
        return this.settings;
    }

    public void encode(BsonOutput bsonOutput, SessionContext sessionContext) {
        Assertions.notNull("sessionContext", sessionContext);
        int messageStartPosition = bsonOutput.getPosition();
        this.writeMessagePrologue(bsonOutput);
        EncodingMetadata encodingMetadata = this.encodeMessageBodyWithMetadata(bsonOutput, sessionContext);
        this.backpatchMessageLength(messageStartPosition, bsonOutput);
        this.encodingMetadata = encodingMetadata;
    }

    public EncodingMetadata getEncodingMetadata() {
        return this.encodingMetadata;
    }

    protected void writeMessagePrologue(BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.id);
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.opCode.getValue());
    }

    protected abstract EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput var1, SessionContext var2);

    protected void addDocument(BsonDocument document, BsonOutput bsonOutput, FieldNameValidator validator, @Nullable List<BsonElement> extraElements) {
        this.addDocument(document, this.getCodec(document), EncoderContext.builder().build(), bsonOutput, validator, this.settings.getMaxDocumentSize() + 16384, extraElements);
    }

    protected void backpatchMessageLength(int startPosition, BsonOutput bsonOutput) {
        int messageLength = bsonOutput.getPosition() - startPosition;
        bsonOutput.writeInt32(bsonOutput.getPosition() - messageLength, messageLength);
    }

    protected String getCollectionName() {
        return this.collectionName;
    }

    Codec<BsonDocument> getCodec(BsonDocument document) {
        return REGISTRY.get(document.getClass());
    }

    private <T> void addDocument(T obj, Encoder<T> encoder, EncoderContext encoderContext, BsonOutput bsonOutput, FieldNameValidator validator, int maxDocumentSize, @Nullable List<BsonElement> extraElements) {
        BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(maxDocumentSize), bsonOutput, validator);
        BsonWriter bsonWriter = extraElements == null ? bsonBinaryWriter : new ElementExtendingBsonWriter(bsonBinaryWriter, extraElements);
        encoder.encode(bsonWriter, obj, encoderContext);
    }

    static class EncodingMetadata {
        private final int firstDocumentPosition;

        EncodingMetadata(int firstDocumentPosition) {
            this.firstDocumentPosition = firstDocumentPosition;
        }

        public int getFirstDocumentPosition() {
            return this.firstDocumentPosition;
        }
    }
}

