/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.AuthenticationMechanism;
import com.dimensionrogue.libs.mongodb.MongoCredential;
import com.dimensionrogue.libs.mongodb.internal.Locks;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MongoCredentialWithCache {
    private final MongoCredential credential;
    private final Cache cache;

    public MongoCredentialWithCache(MongoCredential credential) {
        this(credential, null);
    }

    private MongoCredentialWithCache(MongoCredential credential, @Nullable Cache cache) {
        this.credential = credential;
        this.cache = cache != null ? cache : new Cache();
    }

    public MongoCredentialWithCache withMechanism(AuthenticationMechanism mechanism) {
        return new MongoCredentialWithCache(this.credential.withMechanism(mechanism), this.cache);
    }

    @Nullable
    public AuthenticationMechanism getAuthenticationMechanism() {
        return this.credential.getAuthenticationMechanism();
    }

    public MongoCredential getCredential() {
        return this.credential;
    }

    @Nullable
    public <T> T getFromCache(Object key, Class<T> clazz) {
        return clazz.cast(this.cache.get(key));
    }

    public void putInCache(Object key, Object value) {
        this.cache.set(key, value);
    }

    public Lock getLock() {
        return this.cache.lock;
    }

    static class Cache {
        private final ReentrantLock lock = new ReentrantLock();
        private Object cacheKey;
        private Object cacheValue;

        Cache() {
        }

        Object get(Object key) {
            return Locks.withInterruptibleLock((Lock)this.lock, () -> {
                if (this.cacheKey != null && this.cacheKey.equals(key)) {
                    return this.cacheValue;
                }
                return null;
            });
        }

        void set(Object key, Object value) {
            Locks.withInterruptibleLock((Lock)this.lock, () -> {
                this.cacheKey = key;
                this.cacheValue = value;
            });
        }
    }
}

