/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.LoggerSettings;
import com.dimensionrogue.libs.mongodb.MongoCompressor;
import com.dimensionrogue.libs.mongodb.MongoCredential;
import com.dimensionrogue.libs.mongodb.MongoDriverInformation;
import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.annotations.ThreadSafe;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.connection.ConnectionPoolSettings;
import com.dimensionrogue.libs.mongodb.connection.ServerId;
import com.dimensionrogue.libs.mongodb.connection.ServerSettings;
import com.dimensionrogue.libs.mongodb.connection.StreamFactory;
import com.dimensionrogue.libs.mongodb.event.CommandListener;
import com.dimensionrogue.libs.mongodb.internal.connection.Cluster;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterableServer;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterableServerFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultConnectionFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultConnectionPool;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.LoadBalancedServer;
import com.dimensionrogue.libs.mongodb.internal.connection.MongoCredentialWithCache;
import com.dimensionrogue.libs.mongodb.internal.event.EventListenerHelper;
import com.dimensionrogue.libs.mongodb.internal.inject.EmptyProvider;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import com.dimensionrogue.libs.mongodb.spi.dns.InetAddressResolver;
import java.util.List;

@ThreadSafe
public class LoadBalancedClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    private final ServerApi serverApi;
    private final InetAddressResolver inetAddressResolver;

    public LoadBalancedClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi, @Nullable InetAddressResolver inetAddressResolver) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
        this.inetAddressResolver = inetAddressResolver;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(cluster.getClusterId(), serverAddress), new InternalStreamConnectionFactory(ClusterConnectionMode.LOAD_BALANCED, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi, this.inetAddressResolver), this.connectionPoolSettings, this.internalConnectionPoolSettings, EmptyProvider.instance());
        connectionPool.ready();
        return new LoadBalancedServer(new ServerId(cluster.getClusterId(), serverAddress), connectionPool, new DefaultConnectionFactory(), EventListenerHelper.singleServerListener(this.serverSettings), cluster.getClock());
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

