/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.bson.BsonWriter;
import com.dimensionrogue.libs.mongodb.internal.connection.BsonWriterDecorator;

abstract class LevelCountingBsonWriter
extends BsonWriterDecorator {
    private int level = -1;

    LevelCountingBsonWriter(BsonWriter bsonWriter) {
        super(bsonWriter);
    }

    int getCurrentLevel() {
        return this.level;
    }

    @Override
    public void writeStartDocument(String name) {
        ++this.level;
        super.writeStartDocument(name);
    }

    @Override
    public void writeStartDocument() {
        ++this.level;
        super.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        --this.level;
        super.writeEndDocument();
    }

    @Override
    public void writeStartArray() {
        ++this.level;
        super.writeStartArray();
    }

    @Override
    public void writeStartArray(String name) {
        ++this.level;
        super.writeStartArray(name);
    }

    @Override
    public void writeEndArray() {
        --this.level;
        super.writeEndArray();
    }
}

