/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.bson.ByteBuf;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.mongodb.RequestContext;
import com.dimensionrogue.libs.mongodb.connection.BufferProvider;
import com.dimensionrogue.libs.mongodb.connection.ConnectionDescription;
import com.dimensionrogue.libs.mongodb.connection.ServerDescription;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.connection.CommandMessage;
import com.dimensionrogue.libs.mongodb.internal.connection.Connection;
import com.dimensionrogue.libs.mongodb.internal.connection.OperationContext;
import com.dimensionrogue.libs.mongodb.internal.connection.ResponseBuffers;
import com.dimensionrogue.libs.mongodb.internal.session.SessionContext;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.List;

public interface InternalConnection
extends BufferProvider {
    public static final int NOT_INITIALIZED_GENERATION = -1;

    public ConnectionDescription getDescription();

    public ServerDescription getInitialServerDescription();

    public void open();

    public void openAsync(SingleResultCallback<Void> var1);

    public void close();

    public boolean opened();

    public boolean isClosed();

    public int getGeneration();

    @Nullable
    public <T> T sendAndReceive(CommandMessage var1, Decoder<T> var2, SessionContext var3, RequestContext var4, OperationContext var5);

    public <T> void send(CommandMessage var1, Decoder<T> var2, SessionContext var3);

    public <T> T receive(Decoder<T> var1, SessionContext var2);

    default public boolean supportsAdditionalTimeout() {
        return false;
    }

    default public <T> T receive(Decoder<T> decoder, SessionContext sessionContext, int additionalTimeout) {
        throw new UnsupportedOperationException();
    }

    public boolean hasMoreToCome();

    public <T> void sendAndReceiveAsync(CommandMessage var1, Decoder<T> var2, SessionContext var3, RequestContext var4, OperationContext var5, SingleResultCallback<T> var6);

    public void sendMessage(List<ByteBuf> var1, int var2);

    public ResponseBuffers receiveMessage(int var1);

    public void sendMessageAsync(List<ByteBuf> var1, int var2, SingleResultCallback<Void> var3);

    public void receiveMessageAsync(int var1, SingleResultCallback<ResponseBuffers> var2);

    default public void markAsPinned(Connection.PinningMode pinningMode) {
    }
}

