/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

final class InetAddressUtils {
    private static final int IPV4_PART_COUNT = 4;
    private static final int IPV6_PART_COUNT = 8;
    private static final char IPV4_DELIMITER = '.';
    private static final char IPV6_DELIMITER = ':';

    private InetAddressUtils() {
    }

    static InetAddress forString(String ipString) {
        byte[] addr = InetAddressUtils.ipStringToBytes(ipString);
        if (addr == null) {
            throw new IllegalArgumentException(ipString + " IP address is incorrect");
        }
        return InetAddressUtils.bytesToInetAddress(addr);
    }

    static boolean isInetAddress(String ipString) {
        return InetAddressUtils.ipStringToBytes(ipString) != null;
    }

    @Nullable
    static byte[] ipStringToBytes(String ipStringParam) {
        String ipString = ipStringParam;
        boolean hasColon = false;
        boolean hasDot = false;
        int percentIndex = -1;
        for (int i = 0; i < ipString.length(); ++i) {
            char c = ipString.charAt(i);
            if (c == '.') {
                hasDot = true;
                continue;
            }
            if (c == ':') {
                if (hasDot) {
                    return null;
                }
                hasColon = true;
                continue;
            }
            if (c == '%') {
                percentIndex = i;
                break;
            }
            if (Character.digit(c, 16) != -1) continue;
            return null;
        }
        if (hasColon) {
            if (hasDot && (ipString = InetAddressUtils.convertDottedQuadToHex(ipString)) == null) {
                return null;
            }
            if (percentIndex != -1) {
                ipString = ipString.substring(0, percentIndex);
            }
            return InetAddressUtils.textToNumericFormatV6(ipString);
        }
        if (hasDot) {
            if (percentIndex != -1) {
                return null;
            }
            return InetAddressUtils.textToNumericFormatV4(ipString);
        }
        return null;
    }

    private static boolean hasCorrectNumberOfOctets(String sequence) {
        int matches = 3;
        int index = 0;
        while (matches-- > 0) {
            if ((index = sequence.indexOf(46, index)) == -1) {
                return false;
            }
            ++index;
        }
        return sequence.indexOf(46, index) == -1;
    }

    private static int countIn(CharSequence sequence, char character) {
        int count = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            if (sequence.charAt(i) != character) continue;
            ++count;
        }
        return count;
    }

    @Nullable
    private static byte[] textToNumericFormatV4(String ipString) {
        if (!InetAddressUtils.hasCorrectNumberOfOctets(ipString)) {
            return null;
        }
        byte[] bytes = new byte[4];
        int start = 0;
        for (int i = 0; i < 4; ++i) {
            int end = ipString.indexOf(46, start);
            if (end == -1) {
                end = ipString.length();
            }
            try {
                bytes[i] = InetAddressUtils.parseOctet(ipString, start, end);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            start = end + 1;
        }
        return bytes;
    }

    @Nullable
    private static byte[] textToNumericFormatV6(String ipString) {
        int delimiterCount = InetAddressUtils.countIn(ipString, ':');
        if (delimiterCount < 2 || delimiterCount > 8) {
            return null;
        }
        int partsSkipped = 8 - (delimiterCount + 1);
        boolean hasSkip = false;
        for (int i = 0; i < ipString.length() - 1; ++i) {
            if (ipString.charAt(i) != ':' || ipString.charAt(i + 1) != ':') continue;
            if (hasSkip) {
                return null;
            }
            hasSkip = true;
            ++partsSkipped;
            if (i == 0) {
                ++partsSkipped;
            }
            if (i != ipString.length() - 2) continue;
            ++partsSkipped;
        }
        if (ipString.charAt(0) == ':' && ipString.charAt(1) != ':') {
            return null;
        }
        if (ipString.charAt(ipString.length() - 1) == ':' && ipString.charAt(ipString.length() - 2) != ':') {
            return null;
        }
        if (hasSkip && partsSkipped <= 0) {
            return null;
        }
        if (!hasSkip && delimiterCount + 1 != 8) {
            return null;
        }
        ByteBuffer rawBytes = ByteBuffer.allocate(16);
        try {
            int start = 0;
            if (ipString.charAt(0) == ':') {
                start = 1;
            }
            while (start < ipString.length()) {
                int end = ipString.indexOf(58, start);
                if (end == -1) {
                    end = ipString.length();
                }
                if (ipString.charAt(start) == ':') {
                    for (int i = 0; i < partsSkipped; ++i) {
                        rawBytes.putShort((short)0);
                    }
                } else {
                    rawBytes.putShort(InetAddressUtils.parseHextet(ipString, start, end));
                }
                start = end + 1;
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return rawBytes.array();
    }

    @Nullable
    private static String convertDottedQuadToHex(String ipString) {
        int lastColon = ipString.lastIndexOf(58);
        String initialPart = ipString.substring(0, lastColon + 1);
        String dottedQuad = ipString.substring(lastColon + 1);
        byte[] quad = InetAddressUtils.textToNumericFormatV4(dottedQuad);
        if (quad == null) {
            return null;
        }
        String penultimate = Integer.toHexString((quad[0] & 0xFF) << 8 | quad[1] & 0xFF);
        String ultimate = Integer.toHexString((quad[2] & 0xFF) << 8 | quad[3] & 0xFF);
        return initialPart + penultimate + ":" + ultimate;
    }

    private static byte parseOctet(String ipString, int start, int end) {
        int length = end - start;
        if (length <= 0 || length > 3) {
            throw new NumberFormatException();
        }
        if (length > 1 && ipString.charAt(start) == '0') {
            throw new NumberFormatException("IP address octal representation is not supported");
        }
        int octet = 0;
        for (int i = start; i < end; ++i) {
            octet *= 10;
            int digit = Character.digit(ipString.charAt(i), 10);
            if (digit < 0) {
                throw new NumberFormatException();
            }
            octet += digit;
        }
        if (octet > 255) {
            throw new NumberFormatException();
        }
        return (byte)octet;
    }

    private static short parseHextet(String ipString, int start, int end) {
        int length = end - start;
        if (length <= 0 || length > 4) {
            throw new NumberFormatException();
        }
        int hextet = 0;
        for (int i = start; i < end; ++i) {
            hextet <<= 4;
            hextet |= Character.digit(ipString.charAt(i), 16);
        }
        return (short)hextet;
    }

    private static InetAddress bytesToInetAddress(byte[] addr) {
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }
}

