/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.bson.BsonBoolean;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonInt32;
import com.dimensionrogue.libs.bson.BsonInt64;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.bson.types.ObjectId;
import com.dimensionrogue.libs.mongodb.MongoInterruptedException;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.MongoSocketException;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.annotations.ThreadSafe;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.connection.ServerDescription;
import com.dimensionrogue.libs.mongodb.connection.ServerId;
import com.dimensionrogue.libs.mongodb.connection.ServerSettings;
import com.dimensionrogue.libs.mongodb.connection.ServerType;
import com.dimensionrogue.libs.mongodb.event.ServerHeartbeatFailedEvent;
import com.dimensionrogue.libs.mongodb.event.ServerHeartbeatStartedEvent;
import com.dimensionrogue.libs.mongodb.event.ServerHeartbeatSucceededEvent;
import com.dimensionrogue.libs.mongodb.event.ServerMonitorListener;
import com.dimensionrogue.libs.mongodb.internal.Locks;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterClock;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.dimensionrogue.libs.mongodb.internal.connection.CommandHelper;
import com.dimensionrogue.libs.mongodb.internal.connection.CommandMessage;
import com.dimensionrogue.libs.mongodb.internal.connection.DescriptionHelper;
import com.dimensionrogue.libs.mongodb.internal.connection.ExponentiallyWeightedMovingAverage;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnection;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnectionFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.MessageSettings;
import com.dimensionrogue.libs.mongodb.internal.connection.NoOpSessionContext;
import com.dimensionrogue.libs.mongodb.internal.connection.SdamServerDescriptionManager;
import com.dimensionrogue.libs.mongodb.internal.connection.ServerDescriptionHelper;
import com.dimensionrogue.libs.mongodb.internal.connection.ServerMonitor;
import com.dimensionrogue.libs.mongodb.internal.diagnostics.logging.Logger;
import com.dimensionrogue.libs.mongodb.internal.diagnostics.logging.Loggers;
import com.dimensionrogue.libs.mongodb.internal.event.EventListenerHelper;
import com.dimensionrogue.libs.mongodb.internal.inject.Provider;
import com.dimensionrogue.libs.mongodb.internal.validator.NoOpFieldNameValidator;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
class DefaultServerMonitor
implements ServerMonitor {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final ServerId serverId;
    private final ServerMonitorListener serverMonitorListener;
    private final ClusterClock clusterClock;
    private final Provider<SdamServerDescriptionManager> sdamProvider;
    private final InternalConnectionFactory internalConnectionFactory;
    private final ClusterConnectionMode clusterConnectionMode;
    @Nullable
    private final ServerApi serverApi;
    private final ServerSettings serverSettings;
    private final ServerMonitorRunnable monitor;
    private final Thread monitorThread;
    private final RoundTripTimeRunnable roundTripTimeMonitor;
    private final ExponentiallyWeightedMovingAverage averageRoundTripTime = new ExponentiallyWeightedMovingAverage(0.2);
    private final Thread roundTripTimeMonitorThread;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean isClosed;

    DefaultServerMonitor(ServerId serverId, ServerSettings serverSettings, ClusterClock clusterClock, InternalConnectionFactory internalConnectionFactory, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, Provider<SdamServerDescriptionManager> sdamProvider) {
        this.serverSettings = Assertions.notNull("serverSettings", serverSettings);
        this.serverId = Assertions.notNull("serverId", serverId);
        this.serverMonitorListener = EventListenerHelper.singleServerMonitorListener(serverSettings);
        this.clusterClock = Assertions.notNull("clusterClock", clusterClock);
        this.internalConnectionFactory = Assertions.notNull("internalConnectionFactory", internalConnectionFactory);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
        this.sdamProvider = sdamProvider;
        this.monitor = new ServerMonitorRunnable();
        this.monitorThread = new Thread((Runnable)this.monitor, "cluster-" + this.serverId.getClusterId() + "-" + this.serverId.getAddress());
        this.monitorThread.setDaemon(true);
        this.roundTripTimeMonitor = new RoundTripTimeRunnable();
        this.roundTripTimeMonitorThread = new Thread((Runnable)this.roundTripTimeMonitor, "cluster-rtt-" + this.serverId.getClusterId() + "-" + this.serverId.getAddress());
        this.roundTripTimeMonitorThread.setDaemon(true);
        this.isClosed = false;
    }

    @Override
    public void start() {
        this.monitorThread.start();
        this.roundTripTimeMonitorThread.start();
    }

    @Override
    public void connect() {
        Locks.withLock(this.lock, this.condition::signal);
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.monitor.close();
        this.monitorThread.interrupt();
        this.roundTripTimeMonitor.close();
        this.roundTripTimeMonitorThread.interrupt();
    }

    @Override
    public void cancelCurrentCheck() {
        this.monitor.cancelCurrentCheck();
    }

    static boolean shouldLogStageChange(ServerDescription previous, ServerDescription current) {
        String thatExceptionMessage;
        Class<?> thatExceptionClass;
        if (previous.isOk() != current.isOk()) {
            return true;
        }
        if (!previous.getAddress().equals(current.getAddress())) {
            return true;
        }
        String previousCanonicalAddress = previous.getCanonicalAddress();
        if (previousCanonicalAddress != null ? !previousCanonicalAddress.equals(current.getCanonicalAddress()) : current.getCanonicalAddress() != null) {
            return true;
        }
        if (!previous.getHosts().equals(current.getHosts())) {
            return true;
        }
        if (!previous.getArbiters().equals(current.getArbiters())) {
            return true;
        }
        if (!previous.getPassives().equals(current.getPassives())) {
            return true;
        }
        String previousPrimary = previous.getPrimary();
        if (previousPrimary != null ? !previousPrimary.equals(current.getPrimary()) : current.getPrimary() != null) {
            return true;
        }
        String previousSetName = previous.getSetName();
        if (previousSetName != null ? !previousSetName.equals(current.getSetName()) : current.getSetName() != null) {
            return true;
        }
        if (previous.getState() != current.getState()) {
            return true;
        }
        if (!previous.getTagSet().equals(current.getTagSet())) {
            return true;
        }
        if (previous.getType() != current.getType()) {
            return true;
        }
        if (previous.getMaxWireVersion() != current.getMaxWireVersion()) {
            return true;
        }
        ObjectId previousElectionId = previous.getElectionId();
        if (previousElectionId != null ? !previousElectionId.equals(current.getElectionId()) : current.getElectionId() != null) {
            return true;
        }
        Integer setVersion = previous.getSetVersion();
        if (setVersion != null ? !setVersion.equals(current.getSetVersion()) : current.getSetVersion() != null) {
            return true;
        }
        Throwable previousException = previous.getException();
        Throwable currentException = current.getException();
        Class<?> thisExceptionClass = previousException != null ? previousException.getClass() : null;
        Class<?> clazz = thatExceptionClass = currentException != null ? currentException.getClass() : null;
        if (!Objects.equals(thisExceptionClass, thatExceptionClass)) {
            return true;
        }
        String thisExceptionMessage = previousException != null ? previousException.getMessage() : null;
        String string = thatExceptionMessage = currentException != null ? currentException.getMessage() : null;
        return !Objects.equals(thisExceptionMessage, thatExceptionMessage);
    }

    private void waitForNext() throws InterruptedException {
        Thread.sleep(this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS));
    }

    private String getHandshakeCommandName(ServerDescription serverDescription) {
        return serverDescription.isHelloOk() ? "hello" : "isMaster";
    }

    class ServerMonitorRunnable
    implements Runnable {
        private volatile InternalConnection connection = null;
        private volatile boolean currentCheckCancelled;

        ServerMonitorRunnable() {
        }

        void close() {
            InternalConnection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
        }

        @Override
        public void run() {
            ServerDescription currentServerDescription = ServerDescriptionHelper.unknownConnectingServerDescription(DefaultServerMonitor.this.serverId, null);
            try {
                while (!DefaultServerMonitor.this.isClosed) {
                    ServerDescription previousServerDescription = currentServerDescription;
                    currentServerDescription = this.lookupServerDescription(currentServerDescription);
                    if (DefaultServerMonitor.this.isClosed) continue;
                    if (this.currentCheckCancelled) {
                        this.waitForNext();
                        this.currentCheckCancelled = false;
                        continue;
                    }
                    this.logStateChange(previousServerDescription, currentServerDescription);
                    ((SdamServerDescriptionManager)DefaultServerMonitor.this.sdamProvider.get()).update(currentServerDescription);
                    if ((this.connection == null || this.shouldStreamResponses(currentServerDescription)) && currentServerDescription.getTopologyVersion() != null && currentServerDescription.getType() != ServerType.UNKNOWN || this.connection != null && this.connection.hasMoreToCome() || currentServerDescription.getException() instanceof MongoSocketException && previousServerDescription.getType() != ServerType.UNKNOWN) continue;
                    this.waitForNext();
                }
            }
            catch (MongoInterruptedException | InterruptedException previousServerDescription) {
            }
            catch (RuntimeException e) {
                LOGGER.error(String.format("Server monitor for %s exiting with exception", DefaultServerMonitor.this.serverId), e);
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        private ServerDescription lookupServerDescription(ServerDescription currentServerDescription) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    this.currentCheckCancelled = false;
                    InternalConnection newConnection = DefaultServerMonitor.this.internalConnectionFactory.create(DefaultServerMonitor.this.serverId);
                    newConnection.open();
                    this.connection = newConnection;
                    DefaultServerMonitor.this.averageRoundTripTime.addSample(this.connection.getInitialServerDescription().getRoundTripTimeNanos());
                    return this.connection.getInitialServerDescription();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Checking status of %s", DefaultServerMonitor.this.serverId.getAddress()));
                }
                DefaultServerMonitor.this.serverMonitorListener.serverHearbeatStarted(new ServerHeartbeatStartedEvent(this.connection.getDescription().getConnectionId()));
                long start = System.nanoTime();
                try {
                    ClusterClockAdvancingSessionContext sessionContext = new ClusterClockAdvancingSessionContext(NoOpSessionContext.INSTANCE, DefaultServerMonitor.this.clusterClock);
                    if (!this.connection.hasMoreToCome()) {
                        BsonDocument helloDocument = new BsonDocument(DefaultServerMonitor.this.getHandshakeCommandName(currentServerDescription), new BsonInt32(1)).append("helloOk", BsonBoolean.TRUE);
                        if (this.shouldStreamResponses(currentServerDescription)) {
                            helloDocument.append("topologyVersion", Assertions.assertNotNull(currentServerDescription.getTopologyVersion()).asDocument());
                            helloDocument.append("maxAwaitTimeMS", new BsonInt64(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS)));
                        }
                        this.connection.send(this.createCommandMessage(helloDocument, this.connection, currentServerDescription), new BsonDocumentCodec(), sessionContext);
                    }
                    BsonDocument helloResult = this.shouldStreamResponses(currentServerDescription) ? this.connection.receive(new BsonDocumentCodec(), sessionContext, Math.toIntExact(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS))) : this.connection.receive(new BsonDocumentCodec(), sessionContext);
                    long elapsedTimeNanos = System.nanoTime() - start;
                    DefaultServerMonitor.this.serverMonitorListener.serverHeartbeatSucceeded(new ServerHeartbeatSucceededEvent(this.connection.getDescription().getConnectionId(), helloResult, elapsedTimeNanos, currentServerDescription.getTopologyVersion() != null));
                    return DescriptionHelper.createServerDescription(DefaultServerMonitor.this.serverId.getAddress(), helloResult, DefaultServerMonitor.this.averageRoundTripTime.getAverage());
                }
                catch (Exception e) {
                    DefaultServerMonitor.this.serverMonitorListener.serverHeartbeatFailed(new ServerHeartbeatFailedEvent(this.connection.getDescription().getConnectionId(), System.nanoTime() - start, currentServerDescription.getTopologyVersion() != null, e));
                    throw e;
                }
            }
            catch (Throwable t) {
                DefaultServerMonitor.this.averageRoundTripTime.reset();
                InternalConnection localConnection = Locks.withLock(DefaultServerMonitor.this.lock, () -> {
                    InternalConnection result = this.connection;
                    this.connection = null;
                    return result;
                });
                if (localConnection != null) {
                    localConnection.close();
                }
                return ServerDescriptionHelper.unknownConnectingServerDescription(DefaultServerMonitor.this.serverId, t);
            }
        }

        private boolean shouldStreamResponses(ServerDescription currentServerDescription) {
            return currentServerDescription.getTopologyVersion() != null && this.connection.supportsAdditionalTimeout();
        }

        private CommandMessage createCommandMessage(BsonDocument command, InternalConnection connection, ServerDescription currentServerDescription) {
            return new CommandMessage(new MongoNamespace("admin", "$cmd"), command, new NoOpFieldNameValidator(), ReadPreference.primary(), MessageSettings.builder().maxWireVersion(connection.getDescription().getMaxWireVersion()).build(), this.shouldStreamResponses(currentServerDescription), DefaultServerMonitor.this.clusterConnectionMode, DefaultServerMonitor.this.serverApi);
        }

        private void logStateChange(ServerDescription previousServerDescription, ServerDescription currentServerDescription) {
            if (DefaultServerMonitor.shouldLogStageChange(previousServerDescription, currentServerDescription)) {
                if (currentServerDescription.getException() != null) {
                    LOGGER.info(String.format("Exception in monitor thread while connecting to server %s", DefaultServerMonitor.this.serverId.getAddress()), Assertions.assertNotNull(currentServerDescription.getException()));
                } else {
                    LOGGER.info(String.format("Monitor thread successfully connected to server with description %s", currentServerDescription));
                }
            }
        }

        private void waitForNext() throws InterruptedException {
            long millisToSleep;
            long minimumNanosToWait;
            long timeWaiting;
            long timeRemaining = this.waitForSignalOrTimeout();
            if (timeRemaining > 0L && (timeWaiting = DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.NANOSECONDS) - timeRemaining) < (minimumNanosToWait = DefaultServerMonitor.this.serverSettings.getMinHeartbeatFrequency(TimeUnit.NANOSECONDS)) && (millisToSleep = TimeUnit.MILLISECONDS.convert(minimumNanosToWait - timeWaiting, TimeUnit.NANOSECONDS)) > 0L) {
                Thread.sleep(millisToSleep);
            }
        }

        private long waitForSignalOrTimeout() throws InterruptedException {
            return Locks.checkedWithLock(DefaultServerMonitor.this.lock, () -> DefaultServerMonitor.this.condition.awaitNanos(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.NANOSECONDS)));
        }

        public void cancelCurrentCheck() {
            InternalConnection localConnection = Locks.withLock(DefaultServerMonitor.this.lock, () -> {
                if (this.connection != null && !this.currentCheckCancelled) {
                    InternalConnection result = this.connection;
                    this.currentCheckCancelled = true;
                    return result;
                }
                return null;
            });
            if (localConnection != null) {
                localConnection.close();
            }
        }
    }

    private class RoundTripTimeRunnable
    implements Runnable {
        private volatile InternalConnection connection = null;

        private RoundTripTimeRunnable() {
        }

        void close() {
            InternalConnection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
        }

        @Override
        public void run() {
            try {
                while (!DefaultServerMonitor.this.isClosed) {
                    block10: {
                        try {
                            if (this.connection == null) {
                                this.initialize();
                            } else {
                                this.pingServer(this.connection);
                            }
                        }
                        catch (Throwable t) {
                            if (this.connection == null) break block10;
                            this.connection.close();
                            this.connection = null;
                        }
                    }
                    DefaultServerMonitor.this.waitForNext();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        private void initialize() {
            this.connection = null;
            this.connection = DefaultServerMonitor.this.internalConnectionFactory.create(DefaultServerMonitor.this.serverId);
            this.connection.open();
            DefaultServerMonitor.this.averageRoundTripTime.addSample(this.connection.getInitialServerDescription().getRoundTripTimeNanos());
        }

        private void pingServer(InternalConnection connection) {
            long start = System.nanoTime();
            CommandHelper.executeCommand("admin", new BsonDocument(DefaultServerMonitor.this.getHandshakeCommandName(connection.getInitialServerDescription()), new BsonInt32(1)), DefaultServerMonitor.this.clusterClock, DefaultServerMonitor.this.clusterConnectionMode, DefaultServerMonitor.this.serverApi, connection);
            long elapsedTimeNanos = System.nanoTime() - start;
            DefaultServerMonitor.this.averageRoundTripTime.addSample(elapsedTimeNanos);
        }
    }
}

