/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.FieldNameValidator;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.connection.ConnectionDescription;
import com.dimensionrogue.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.BindingContext;
import com.dimensionrogue.libs.mongodb.internal.connection.AbstractReferenceCounted;
import com.dimensionrogue.libs.mongodb.internal.connection.AsyncConnection;
import com.dimensionrogue.libs.mongodb.internal.connection.CommandProtocol;
import com.dimensionrogue.libs.mongodb.internal.connection.CommandProtocolImpl;
import com.dimensionrogue.libs.mongodb.internal.connection.Connection;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnection;
import com.dimensionrogue.libs.mongodb.internal.connection.ProtocolExecutor;
import com.dimensionrogue.libs.mongodb.internal.connection.SplittablePayload;
import com.dimensionrogue.libs.mongodb.internal.diagnostics.logging.Logger;
import com.dimensionrogue.libs.mongodb.internal.diagnostics.logging.Loggers;
import com.dimensionrogue.libs.mongodb.internal.session.SessionContext;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

public class DefaultServerConnection
extends AbstractReferenceCounted
implements Connection,
AsyncConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final InternalConnection wrapped;
    private final ProtocolExecutor protocolExecutor;
    private final ClusterConnectionMode clusterConnectionMode;

    public DefaultServerConnection(InternalConnection wrapped, ProtocolExecutor protocolExecutor, ClusterConnectionMode clusterConnectionMode) {
        this.wrapped = wrapped;
        this.protocolExecutor = protocolExecutor;
        this.clusterConnectionMode = clusterConnectionMode;
    }

    @Override
    public DefaultServerConnection retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.close();
        }
        return count;
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    @Nullable
    public <T> T command(String database, BsonDocument command, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context) {
        return this.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, context, true, null, null);
    }

    @Override
    @Nullable
    public <T> T command(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator) {
        return this.executeProtocol(new CommandProtocolImpl<T>(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, context.getServerApi(), context.getRequestContext(), context.getOperationContext()), context.getSessionContext());
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context, SingleResultCallback<T> callback) {
        this.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, context, true, null, null, callback);
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, SingleResultCallback<T> callback) {
        this.executeProtocolAsync(new CommandProtocolImpl<T>(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, context.getServerApi(), context.getRequestContext(), context.getOperationContext()), context.getSessionContext(), callback);
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }

    @Nullable
    private <T> T executeProtocol(CommandProtocol<T> protocol, SessionContext sessionContext) {
        return this.protocolExecutor.execute(protocol, this.wrapped, sessionContext);
    }

    private <T> void executeProtocolAsync(CommandProtocol<T> protocol, SessionContext sessionContext, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        try {
            this.protocolExecutor.executeAsync(protocol, this.wrapped, sessionContext, errHandlingCallback);
        }
        catch (Throwable t) {
            errHandlingCallback.onResult(null, t);
        }
    }
}

