/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.connection.ClusterId;
import com.dimensionrogue.libs.mongodb.connection.ServerSettings;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultDnsSrvRecordMonitor;
import com.dimensionrogue.libs.mongodb.internal.connection.DnsSrvRecordInitializer;
import com.dimensionrogue.libs.mongodb.internal.connection.DnsSrvRecordMonitor;
import com.dimensionrogue.libs.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import com.dimensionrogue.libs.mongodb.internal.dns.DefaultDnsResolver;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import com.dimensionrogue.libs.mongodb.spi.dns.DnsClient;
import java.util.concurrent.TimeUnit;

public class DefaultDnsSrvRecordMonitorFactory
implements DnsSrvRecordMonitorFactory {
    private static final long DEFAULT_RESCAN_FREQUENCY_MILLIS = 60000L;
    private final ClusterId clusterId;
    private final long noRecordsRescanFrequency;
    private final DnsClient dnsClient;

    public DefaultDnsSrvRecordMonitorFactory(ClusterId clusterId, ServerSettings serverSettings, @Nullable DnsClient dnsClient) {
        this.clusterId = clusterId;
        this.noRecordsRescanFrequency = serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS);
        this.dnsClient = dnsClient;
    }

    @Override
    public DnsSrvRecordMonitor create(String hostName, String srvServiceName, DnsSrvRecordInitializer dnsSrvRecordInitializer) {
        return new DefaultDnsSrvRecordMonitor(hostName, srvServiceName, 60000L, this.noRecordsRescanFrequency, dnsSrvRecordInitializer, this.clusterId, new DefaultDnsResolver(this.dnsClient));
    }
}

