/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.LoggerSettings;
import com.dimensionrogue.libs.mongodb.MongoCompressor;
import com.dimensionrogue.libs.mongodb.MongoCredential;
import com.dimensionrogue.libs.mongodb.MongoDriverInformation;
import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.connection.ConnectionPoolSettings;
import com.dimensionrogue.libs.mongodb.connection.ServerId;
import com.dimensionrogue.libs.mongodb.connection.ServerSettings;
import com.dimensionrogue.libs.mongodb.connection.StreamFactory;
import com.dimensionrogue.libs.mongodb.event.CommandListener;
import com.dimensionrogue.libs.mongodb.event.ServerListener;
import com.dimensionrogue.libs.mongodb.internal.connection.Cluster;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterableServer;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterableServerFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultConnectionFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultConnectionPool;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultSdamServerDescriptionManager;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultServer;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultServerMonitor;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.MongoCredentialWithCache;
import com.dimensionrogue.libs.mongodb.internal.connection.SdamServerDescriptionManager;
import com.dimensionrogue.libs.mongodb.internal.event.EventListenerHelper;
import com.dimensionrogue.libs.mongodb.internal.inject.SameObjectProvider;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import com.dimensionrogue.libs.mongodb.spi.dns.InetAddressResolver;
import java.util.Collections;
import java.util.List;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final StreamFactory heartbeatStreamFactory;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    @Nullable
    private final ServerApi serverApi;
    @Nullable
    private final InetAddressResolver inetAddressResolver;

    public DefaultClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi, @Nullable InetAddressResolver inetAddressResolver) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
        this.inetAddressResolver = inetAddressResolver;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        ServerId serverId = new ServerId(cluster.getClusterId(), serverAddress);
        ClusterConnectionMode clusterMode = cluster.getSettings().getMode();
        SameObjectProvider<SdamServerDescriptionManager> sdamProvider = SameObjectProvider.uninitialized();
        DefaultServerMonitor serverMonitor = new DefaultServerMonitor(serverId, this.serverSettings, cluster.getClock(), new InternalStreamConnectionFactory(clusterMode, true, this.heartbeatStreamFactory, null, this.applicationName, this.mongoDriverInformation, Collections.emptyList(), this.loggerSettings, null, this.serverApi, this.inetAddressResolver), clusterMode, this.serverApi, sdamProvider);
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(serverId, new InternalStreamConnectionFactory(clusterMode, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi, this.inetAddressResolver), this.connectionPoolSettings, this.internalConnectionPoolSettings, sdamProvider);
        ServerListener serverListener = EventListenerHelper.singleServerListener(this.serverSettings);
        DefaultSdamServerDescriptionManager sdam = new DefaultSdamServerDescriptionManager(cluster, serverId, serverListener, serverMonitor, connectionPool, clusterMode);
        sdamProvider.initialize(sdam);
        serverMonitor.start();
        return new DefaultServer(serverId, clusterMode, connectionPool, new DefaultConnectionFactory(), serverMonitor, sdam, serverListener, this.commandListener, cluster.getClock(), true);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

