/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.LoggerSettings;
import com.dimensionrogue.libs.mongodb.MongoCompressor;
import com.dimensionrogue.libs.mongodb.MongoCredential;
import com.dimensionrogue.libs.mongodb.MongoDriverInformation;
import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.connection.ClusterId;
import com.dimensionrogue.libs.mongodb.connection.ClusterSettings;
import com.dimensionrogue.libs.mongodb.connection.ConnectionPoolSettings;
import com.dimensionrogue.libs.mongodb.connection.ServerSettings;
import com.dimensionrogue.libs.mongodb.connection.StreamFactory;
import com.dimensionrogue.libs.mongodb.event.ClusterListener;
import com.dimensionrogue.libs.mongodb.event.CommandListener;
import com.dimensionrogue.libs.mongodb.event.ServerListener;
import com.dimensionrogue.libs.mongodb.event.ServerMonitorListener;
import com.dimensionrogue.libs.mongodb.internal.connection.AsynchronousClusterEventListener;
import com.dimensionrogue.libs.mongodb.internal.connection.Cluster;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultClusterableServerFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.DefaultDnsSrvRecordMonitorFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.DnsMultiServerCluster;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.dimensionrogue.libs.mongodb.internal.connection.LoadBalancedCluster;
import com.dimensionrogue.libs.mongodb.internal.connection.LoadBalancedClusterableServerFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.MultiServerCluster;
import com.dimensionrogue.libs.mongodb.internal.connection.SingleServerCluster;
import com.dimensionrogue.libs.mongodb.internal.diagnostics.logging.Logger;
import com.dimensionrogue.libs.mongodb.internal.diagnostics.logging.Loggers;
import com.dimensionrogue.libs.mongodb.internal.event.EventListenerHelper;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import com.dimensionrogue.libs.mongodb.spi.dns.DnsClient;
import com.dimensionrogue.libs.mongodb.spi.dns.InetAddressResolver;
import java.util.Collections;
import java.util.List;

public final class DefaultClusterFactory {
    private static final Logger LOGGER = Loggers.getLogger("client");

    public Cluster createCluster(ClusterSettings originalClusterSettings, ServerSettings originalServerSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi, @Nullable DnsClient dnsClient, @Nullable InetAddressResolver inetAddressResolver) {
        ServerSettings serverSettings;
        ClusterSettings clusterSettings;
        this.detectAndLogClusterEnvironment(originalClusterSettings);
        ClusterId clusterId = new ClusterId(applicationName);
        if (this.noClusterEventListeners(originalClusterSettings, originalServerSettings)) {
            clusterSettings = ClusterSettings.builder(originalClusterSettings).clusterListenerList(Collections.singletonList(EventListenerHelper.NO_OP_CLUSTER_LISTENER)).build();
            serverSettings = ServerSettings.builder(originalServerSettings).serverListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_LISTENER)).serverMonitorListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER)).build();
        } else {
            AsynchronousClusterEventListener clusterEventListener = AsynchronousClusterEventListener.startNew(clusterId, DefaultClusterFactory.getClusterListener(originalClusterSettings), DefaultClusterFactory.getServerListener(originalServerSettings), DefaultClusterFactory.getServerMonitorListener(originalServerSettings));
            clusterSettings = ClusterSettings.builder(originalClusterSettings).clusterListenerList(Collections.singletonList(clusterEventListener)).build();
            serverSettings = ServerSettings.builder(originalServerSettings).serverListenerList(Collections.singletonList(clusterEventListener)).serverMonitorListenerList(Collections.singletonList(clusterEventListener)).build();
        }
        DefaultDnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory = new DefaultDnsSrvRecordMonitorFactory(clusterId, serverSettings, dnsClient);
        if (clusterSettings.getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            LoadBalancedClusterableServerFactory serverFactory = new LoadBalancedClusterableServerFactory(serverSettings, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, credential, loggerSettings, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList, serverApi, inetAddressResolver);
            return new LoadBalancedCluster(clusterId, clusterSettings, serverFactory, dnsSrvRecordMonitorFactory);
        }
        DefaultClusterableServerFactory serverFactory = new DefaultClusterableServerFactory(serverSettings, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, heartbeatStreamFactory, credential, loggerSettings, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList, serverApi, inetAddressResolver);
        if (clusterSettings.getMode() == ClusterConnectionMode.SINGLE) {
            return new SingleServerCluster(clusterId, clusterSettings, serverFactory);
        }
        if (clusterSettings.getMode() == ClusterConnectionMode.MULTIPLE) {
            if (clusterSettings.getSrvHost() == null) {
                return new MultiServerCluster(clusterId, clusterSettings, serverFactory);
            }
            return new DnsMultiServerCluster(clusterId, clusterSettings, serverFactory, dnsSrvRecordMonitorFactory);
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)clusterSettings.getMode()));
    }

    private boolean noClusterEventListeners(ClusterSettings clusterSettings, ServerSettings serverSettings) {
        return clusterSettings.getClusterListeners().isEmpty() && serverSettings.getServerListeners().isEmpty() && serverSettings.getServerMonitorListeners().isEmpty();
    }

    private static ClusterListener getClusterListener(ClusterSettings clusterSettings) {
        return clusterSettings.getClusterListeners().size() == 0 ? EventListenerHelper.NO_OP_CLUSTER_LISTENER : EventListenerHelper.clusterListenerMulticaster(clusterSettings.getClusterListeners());
    }

    private static ServerListener getServerListener(ServerSettings serverSettings) {
        return serverSettings.getServerListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_LISTENER : EventListenerHelper.serverListenerMulticaster(serverSettings.getServerListeners());
    }

    private static ServerMonitorListener getServerMonitorListener(ServerSettings serverSettings) {
        return serverSettings.getServerMonitorListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER : EventListenerHelper.serverMonitorListenerMulticaster(serverSettings.getServerMonitorListeners());
    }

    public void detectAndLogClusterEnvironment(ClusterSettings clusterSettings) {
        String srvHost = clusterSettings.getSrvHost();
        ClusterEnvironment clusterEnvironment = srvHost != null ? ClusterEnvironment.detectCluster(srvHost) : ClusterEnvironment.detectCluster((String[])clusterSettings.getHosts().stream().map(ServerAddress::getHost).toArray(String[]::new));
        if (clusterEnvironment != null) {
            LOGGER.info(String.format("You appear to be connected to a %s cluster. For more information regarding feature compatibility and support please visit %s", clusterEnvironment.clusterProductName, clusterEnvironment.documentationUrl));
        }
    }

    static enum ClusterEnvironment {
        AZURE("https://www.mongodb.com/supportability/cosmosdb", "CosmosDB", ".cosmos.azure.com"),
        AWS("https://www.mongodb.com/supportability/documentdb", "DocumentDB", ".docdb.amazonaws.com", ".docdb-elastic.amazonaws.com");

        private final String documentationUrl;
        private final String clusterProductName;
        private final String[] hostSuffixes;

        private ClusterEnvironment(String url, String name, String ... hostSuffixes) {
            this.hostSuffixes = hostSuffixes;
            this.documentationUrl = url;
            this.clusterProductName = name;
        }

        @Nullable
        public static ClusterEnvironment detectCluster(String ... hosts) {
            for (String host : hosts) {
                for (ClusterEnvironment clusterEnvironment : ClusterEnvironment.values()) {
                    if (!clusterEnvironment.isExternalClusterProvider(host)) continue;
                    return clusterEnvironment;
                }
            }
            return null;
        }

        private boolean isExternalClusterProvider(String host) {
            for (String hostSuffix : this.hostSuffixes) {
                String lowerCaseHost = host.toLowerCase();
                if (!lowerCaseHost.endsWith(hostSuffix)) continue;
                return true;
            }
            return false;
        }
    }
}

