/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.FieldNameValidator;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.RequestContext;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.connection.CommandMessage;
import com.dimensionrogue.libs.mongodb.internal.connection.CommandProtocol;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnection;
import com.dimensionrogue.libs.mongodb.internal.connection.OperationContext;
import com.dimensionrogue.libs.mongodb.internal.connection.ProtocolHelper;
import com.dimensionrogue.libs.mongodb.internal.connection.SplittablePayload;
import com.dimensionrogue.libs.mongodb.internal.session.SessionContext;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

class CommandProtocolImpl<T>
implements CommandProtocol<T> {
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final SplittablePayload payload;
    private final ReadPreference readPreference;
    private final FieldNameValidator commandFieldNameValidator;
    private final FieldNameValidator payloadFieldNameValidator;
    private final Decoder<T> commandResultDecoder;
    private final boolean responseExpected;
    private final ClusterConnectionMode clusterConnectionMode;
    private final RequestContext requestContext;
    private SessionContext sessionContext;
    private final ServerApi serverApi;
    private final OperationContext operationContext;

    CommandProtocolImpl(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, RequestContext requestContext, OperationContext operationContext) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(Assertions.notNull("database", database), "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandFieldNameValidator = Assertions.notNull("commandFieldNameValidator", commandFieldNameValidator);
        this.readPreference = readPreference;
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.responseExpected = responseExpected;
        this.payload = payload;
        this.payloadFieldNameValidator = payloadFieldNameValidator;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
        this.operationContext = operationContext;
        Assertions.isTrueArgument("payloadFieldNameValidator cannot be null if there is a payload.", payload == null || payloadFieldNameValidator != null);
    }

    @Override
    @Nullable
    public T execute(InternalConnection connection) {
        return connection.sendAndReceive(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext, this.requestContext, this.operationContext);
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<T> callback) {
        try {
            connection.sendAndReceiveAsync(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext, this.requestContext, this.operationContext, (result, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(result, null);
                }
            });
        }
        catch (Throwable t2) {
            callback.onResult(null, t2);
        }
    }

    @Override
    public CommandProtocolImpl<T> sessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }

    private CommandMessage getCommandMessage(InternalConnection connection) {
        return new CommandMessage(this.namespace, this.command, this.commandFieldNameValidator, this.readPreference, ProtocolHelper.getMessageSettings(connection.getDescription()), this.responseExpected, this.payload, this.payloadFieldNameValidator, this.clusterConnectionMode, this.serverApi);
    }
}

