/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.MongoServerException;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.internal.IgnorableRequestContext;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterClock;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.dimensionrogue.libs.mongodb.internal.connection.CommandMessage;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnection;
import com.dimensionrogue.libs.mongodb.internal.connection.MessageSettings;
import com.dimensionrogue.libs.mongodb.internal.connection.NoOpSessionContext;
import com.dimensionrogue.libs.mongodb.internal.connection.OperationContext;
import com.dimensionrogue.libs.mongodb.internal.session.SessionContext;
import com.dimensionrogue.libs.mongodb.internal.validator.NoOpFieldNameValidator;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.Locale;

public final class CommandHelper {
    static final String HELLO = "hello";
    static final String LEGACY_HELLO = "isMaster";
    static final String LEGACY_HELLO_LOWER = "isMaster".toLowerCase(Locale.ROOT);

    static BsonDocument executeCommand(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, null, clusterConnectionMode, serverApi, internalConnection);
    }

    public static BsonDocument executeCommand(String database, BsonDocument command, ClusterClock clusterClock, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, clusterClock, clusterConnectionMode, serverApi, internalConnection);
    }

    static BsonDocument executeCommandWithoutCheckingForFailure(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        try {
            return CommandHelper.sendAndReceive(database, command, null, clusterConnectionMode, serverApi, internalConnection);
        }
        catch (MongoServerException e) {
            return new BsonDocument();
        }
    }

    static void executeCommandAsync(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection, SingleResultCallback<BsonDocument> callback) {
        internalConnection.sendAndReceiveAsync(CommandHelper.getCommandMessage(database, command, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), NoOpSessionContext.INSTANCE, IgnorableRequestContext.INSTANCE, new OperationContext(), (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((BsonDocument)result, null);
            }
        });
    }

    static boolean isCommandOk(BsonDocument response) {
        if (!response.containsKey("ok")) {
            return false;
        }
        BsonValue okValue = response.get("ok");
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    private static BsonDocument sendAndReceive(String database, BsonDocument command, @Nullable ClusterClock clusterClock, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        SessionContext sessionContext = clusterClock == null ? NoOpSessionContext.INSTANCE : new ClusterClockAdvancingSessionContext(NoOpSessionContext.INSTANCE, clusterClock);
        return Assertions.assertNotNull(internalConnection.sendAndReceive(CommandHelper.getCommandMessage(database, command, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), sessionContext, IgnorableRequestContext.INSTANCE, new OperationContext()));
    }

    private static CommandMessage getCommandMessage(String database, BsonDocument command, InternalConnection internalConnection, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        return new CommandMessage(new MongoNamespace(database, "$cmd"), command, new NoOpFieldNameValidator(), ReadPreference.primary(), MessageSettings.builder().maxWireVersion(internalConnection.getDescription().getMaxWireVersion()).serverType(internalConnection.getDescription().getServerType()).build(), clusterConnectionMode, serverApi);
    }

    private CommandHelper() {
    }
}

