/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.bson.BsonBinaryReader;
import com.dimensionrogue.libs.bson.BsonBoolean;
import com.dimensionrogue.libs.bson.BsonDateTime;
import com.dimensionrogue.libs.bson.BsonDecimal128;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonDouble;
import com.dimensionrogue.libs.bson.BsonInt32;
import com.dimensionrogue.libs.bson.BsonInt64;
import com.dimensionrogue.libs.bson.BsonJavaScript;
import com.dimensionrogue.libs.bson.BsonJavaScriptWithScope;
import com.dimensionrogue.libs.bson.BsonMaxKey;
import com.dimensionrogue.libs.bson.BsonMinKey;
import com.dimensionrogue.libs.bson.BsonNull;
import com.dimensionrogue.libs.bson.BsonObjectId;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonSymbol;
import com.dimensionrogue.libs.bson.BsonUndefined;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.ByteBuf;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.mongodb.internal.connection.ByteBufBsonArray;
import com.dimensionrogue.libs.mongodb.internal.connection.ByteBufBsonDocument;

final class ByteBufBsonHelper {
    static BsonValue readBsonValue(ByteBuf byteBuf, BsonBinaryReader bsonReader) {
        BsonValue value;
        switch (bsonReader.getCurrentBsonType()) {
            case DOCUMENT: {
                ByteBuf documentByteBuf = byteBuf.duplicate();
                value = new ByteBufBsonDocument(documentByteBuf);
                bsonReader.skipValue();
                break;
            }
            case ARRAY: {
                ByteBuf arrayByteBuf = byteBuf.duplicate();
                value = new ByteBufBsonArray(arrayByteBuf);
                bsonReader.skipValue();
                break;
            }
            case INT32: {
                value = new BsonInt32(bsonReader.readInt32());
                break;
            }
            case INT64: {
                value = new BsonInt64(bsonReader.readInt64());
                break;
            }
            case DOUBLE: {
                value = new BsonDouble(bsonReader.readDouble());
                break;
            }
            case DECIMAL128: {
                value = new BsonDecimal128(bsonReader.readDecimal128());
                break;
            }
            case DATE_TIME: {
                value = new BsonDateTime(bsonReader.readDateTime());
                break;
            }
            case TIMESTAMP: {
                value = bsonReader.readTimestamp();
                break;
            }
            case BOOLEAN: {
                value = new BsonBoolean(bsonReader.readBoolean());
                break;
            }
            case OBJECT_ID: {
                value = new BsonObjectId(bsonReader.readObjectId());
                break;
            }
            case STRING: {
                value = new BsonString(bsonReader.readString());
                break;
            }
            case BINARY: {
                value = bsonReader.readBinaryData();
                break;
            }
            case SYMBOL: {
                value = new BsonSymbol(bsonReader.readSymbol());
                break;
            }
            case UNDEFINED: {
                bsonReader.readUndefined();
                value = new BsonUndefined();
                break;
            }
            case REGULAR_EXPRESSION: {
                value = bsonReader.readRegularExpression();
                break;
            }
            case DB_POINTER: {
                value = bsonReader.readDBPointer();
                break;
            }
            case JAVASCRIPT: {
                value = new BsonJavaScript(bsonReader.readJavaScript());
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                String code = bsonReader.readJavaScriptWithScope();
                BsonDocument scope = new BsonDocumentCodec().decode(bsonReader, DecoderContext.builder().build());
                value = new BsonJavaScriptWithScope(code, scope);
                break;
            }
            case MIN_KEY: {
                bsonReader.readMinKey();
                value = new BsonMinKey();
                break;
            }
            case MAX_KEY: {
                bsonReader.readMaxKey();
                value = new BsonMaxKey();
                break;
            }
            case NULL: {
                bsonReader.readNull();
                value = new BsonNull();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected BSON type: " + (Object)((Object)bsonReader.getCurrentBsonType()));
            }
        }
        return value;
    }

    private ByteBufBsonHelper() {
    }
}

