/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.connection;

import com.dimensionrogue.libs.mongodb.MongoCredential;
import com.dimensionrogue.libs.mongodb.MongoInternalException;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.connection.ConnectionDescription;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.connection.InternalConnection;
import com.dimensionrogue.libs.mongodb.internal.connection.MongoCredentialWithCache;
import com.dimensionrogue.libs.mongodb.lang.NonNull;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

public abstract class Authenticator {
    private final MongoCredentialWithCache credential;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ServerApi serverApi;

    Authenticator(@NonNull MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this.credential = credential;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
    }

    @NonNull
    MongoCredentialWithCache getMongoCredentialWithCache() {
        return this.credential;
    }

    @NonNull
    MongoCredential getMongoCredential() {
        return this.credential.getCredential();
    }

    ClusterConnectionMode getClusterConnectionMode() {
        return this.clusterConnectionMode;
    }

    @Nullable
    ServerApi getServerApi() {
        return this.serverApi;
    }

    @NonNull
    String getUserNameNonNull() {
        String userName = this.credential.getCredential().getUserName();
        if (userName == null) {
            throw new MongoInternalException("User name can not be null");
        }
        return userName;
    }

    @NonNull
    char[] getPasswordNonNull() {
        char[] password = this.credential.getCredential().getPassword();
        if (password == null) {
            throw new MongoInternalException("Password can not be null");
        }
        return password;
    }

    @NonNull
    <T> T getNonNullMechanismProperty(String key, @Nullable T defaultValue) {
        T mechanismProperty = this.credential.getCredential().getMechanismProperty(key, defaultValue);
        if (mechanismProperty == null) {
            throw new MongoInternalException("Mechanism property can not be null");
        }
        return mechanismProperty;
    }

    abstract void authenticate(InternalConnection var1, ConnectionDescription var2);

    abstract void authenticateAsync(InternalConnection var1, ConnectionDescription var2, SingleResultCallback<Void> var3);
}

