/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.client.model;

import com.dimensionrogue.libs.bson.BsonArray;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.mongodb.Function;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.search.FieldSearchPath;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchPath;
import java.util.Iterator;

public final class Util {
    public static final String SEARCH_PATH_VALUE_KEY = "value";

    public static BsonValue combineToBsonValue(Iterator<? extends SearchPath> nonEmptyPaths, boolean valueOnly) {
        Function<SearchPath, BsonValue> toBsonValueFunc = valueOnly ? path -> {
            if (path instanceof FieldSearchPath) {
                return new BsonString(((FieldSearchPath)path).toValue());
            }
            return path.toBsonValue();
        } : SearchPath::toBsonValue;
        BsonValue firstPath = toBsonValueFunc.apply(nonEmptyPaths.next());
        if (nonEmptyPaths.hasNext()) {
            BsonArray bsonArray = new BsonArray();
            bsonArray.add(firstPath);
            while (nonEmptyPaths.hasNext()) {
                bsonArray.add(toBsonValueFunc.apply(nonEmptyPaths.next()));
            }
            return bsonArray;
        }
        return firstPath;
    }

    public static boolean sizeAtLeast(Iterable<?> iterable, int minInclusive) {
        int size;
        Iterator<?> iter = iterable.iterator();
        for (size = 0; size < minInclusive && iter.hasNext(); ++size) {
            iter.next();
        }
        return size >= minInclusive;
    }

    private Util() {
        throw Assertions.fail();
    }
}

