/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.binding;

import com.dimensionrogue.libs.mongodb.ReadConcern;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.RequestContext;
import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ClusterConnectionMode;
import com.dimensionrogue.libs.mongodb.connection.ServerDescription;
import com.dimensionrogue.libs.mongodb.internal.binding.AbstractReferenceCounted;
import com.dimensionrogue.libs.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.ConnectionSource;
import com.dimensionrogue.libs.mongodb.internal.binding.ReadWriteBinding;
import com.dimensionrogue.libs.mongodb.internal.connection.Cluster;
import com.dimensionrogue.libs.mongodb.internal.connection.Connection;
import com.dimensionrogue.libs.mongodb.internal.connection.OperationContext;
import com.dimensionrogue.libs.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import com.dimensionrogue.libs.mongodb.internal.connection.Server;
import com.dimensionrogue.libs.mongodb.internal.connection.ServerTuple;
import com.dimensionrogue.libs.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.dimensionrogue.libs.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import com.dimensionrogue.libs.mongodb.internal.selector.ServerAddressSelector;
import com.dimensionrogue.libs.mongodb.internal.selector.WritableServerSelector;
import com.dimensionrogue.libs.mongodb.internal.session.SessionContext;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

public class ClusterBinding
extends AbstractReferenceCounted
implements ClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    @Nullable
    private final ServerApi serverApi;
    private final RequestContext requestContext;
    private final OperationContext operationContext;

    public ClusterBinding(Cluster cluster, ReadPreference readPreference, ReadConcern readConcern, @Nullable ServerApi serverApi, RequestContext requestContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.serverApi = serverApi;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
        this.operationContext = new OperationContext();
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public ReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public SessionContext getSessionContext() {
        return new ReadConcernAwareNoOpSessionContext(this.readConcern);
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Override
    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ReadPreferenceServerSelector(this.readPreference), this.operationContext), this.readPreference);
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            return this.getReadConnectionSource();
        }
        ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, minWireVersion, fallbackReadPreference);
        ServerTuple serverTuple = this.cluster.selectServer(readPreferenceWithFallbackServerSelector, this.operationContext);
        return new ClusterBindingConnectionSource(serverTuple, readPreferenceWithFallbackServerSelector.getAppliedReadPreference());
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new WritableServerSelector(), this.operationContext), this.readPreference);
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ServerAddressSelector(serverAddress), this.operationContext), this.readPreference);
    }

    private final class ClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private ClusterBindingConnectionSource(ServerTuple serverTuple, ReadPreference appliedReadPreference) {
            this.server = serverTuple.getServer();
            this.serverDescription = serverTuple.getServerDescription();
            this.appliedReadPreference = appliedReadPreference;
            ClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public SessionContext getSessionContext() {
            return new ReadConcernAwareNoOpSessionContext(ClusterBinding.this.readConcern);
        }

        @Override
        public OperationContext getOperationContext() {
            return ClusterBinding.this.operationContext;
        }

        @Override
        public ServerApi getServerApi() {
            return ClusterBinding.this.serverApi;
        }

        @Override
        public RequestContext getRequestContext() {
            return ClusterBinding.this.requestContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public Connection getConnection() {
            return this.server.getConnection(ClusterBinding.this.operationContext);
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            ClusterBinding.this.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            ClusterBinding.this.release();
            return count;
        }
    }
}

