/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.event;

import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ConnectionId;

public final class ConnectionClosedEvent {
    private final ConnectionId connectionId;
    private final Reason reason;

    public ConnectionClosedEvent(ConnectionId connectionId, Reason reason) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        this.reason = Assertions.notNull("reason", reason);
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String toString() {
        return "ConnectionClosedEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", reason=" + (Object)((Object)this.reason) + '}';
    }

    public static enum Reason {
        STALE,
        IDLE,
        ERROR,
        POOL_CLOSED;

    }
}

