/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.event;

import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ConnectionId;
import java.util.concurrent.TimeUnit;

public final class ConnectionCheckedOutEvent {
    private final ConnectionId connectionId;
    private final long operationId;
    private final long elapsedTimeNanos;

    public ConnectionCheckedOutEvent(ConnectionId connectionId, long operationId, long elapsedTimeNanos) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        this.operationId = operationId;
        Assertions.isTrueArgument("waited time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    @Deprecated
    public ConnectionCheckedOutEvent(ConnectionId connectionId, long operationId) {
        this(connectionId, operationId, 0L);
    }

    @Deprecated
    public ConnectionCheckedOutEvent(ConnectionId connectionId) {
        this(connectionId, -1L);
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getOperationId() {
        return this.operationId;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "ConnectionCheckedOutEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", operationId=" + this.operationId + ", elapsedTimeNanos=" + this.elapsedTimeNanos + '}';
    }
}

