/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.event;

import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ConnectionId;

public final class ConnectionCheckedInEvent {
    private final ConnectionId connectionId;
    private final long operationId;

    public ConnectionCheckedInEvent(ConnectionId connectionId, long operationId) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        this.operationId = operationId;
    }

    @Deprecated
    public ConnectionCheckedInEvent(ConnectionId connectionId) {
        this(connectionId, -1L);
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getOperationId() {
        return this.operationId;
    }

    public String toString() {
        return "ConnectionCheckedInEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", operationId=" + this.operationId + '}';
    }
}

