/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.event;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.mongodb.RequestContext;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ConnectionDescription;
import com.dimensionrogue.libs.mongodb.event.CommandEvent;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class CommandSucceededEvent
extends CommandEvent {
    private final BsonDocument response;
    private final long elapsedTimeNanos;

    public CommandSucceededEvent(@Nullable RequestContext requestContext, long operationId, int requestId, ConnectionDescription connectionDescription, String databaseName, String commandName, BsonDocument response, long elapsedTimeNanos) {
        super(requestContext, operationId, requestId, connectionDescription, databaseName, commandName);
        this.response = response;
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    @Deprecated
    public CommandSucceededEvent(@Nullable RequestContext requestContext, long operationId, int requestId, ConnectionDescription connectionDescription, String commandName, BsonDocument response, long elapsedTimeNanos) {
        super(requestContext, operationId, requestId, connectionDescription, commandName);
        this.response = response;
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    @Deprecated
    public CommandSucceededEvent(@Nullable RequestContext requestContext, int requestId, ConnectionDescription connectionDescription, String commandName, BsonDocument response, long elapsedTimeNanos) {
        this(requestContext, -1L, requestId, connectionDescription, commandName, response, elapsedTimeNanos);
    }

    @Deprecated
    public CommandSucceededEvent(int requestId, ConnectionDescription connectionDescription, String commandName, BsonDocument response, long elapsedTimeNanos) {
        this(null, requestId, connectionDescription, commandName, response, elapsedTimeNanos);
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public BsonDocument getResponse() {
        return this.response;
    }
}

