/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.connection;

import com.dimensionrogue.libs.mongodb.MongoClientException;
import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.UnixServerAddress;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.BufferProvider;
import com.dimensionrogue.libs.mongodb.connection.SocketSettings;
import com.dimensionrogue.libs.mongodb.connection.SslSettings;
import com.dimensionrogue.libs.mongodb.connection.Stream;
import com.dimensionrogue.libs.mongodb.connection.StreamFactory;
import com.dimensionrogue.libs.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.dimensionrogue.libs.mongodb.internal.connection.SocketStream;
import com.dimensionrogue.libs.mongodb.internal.connection.UnixSocketChannelStream;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

@Deprecated
public class SocketStreamFactory
implements StreamFactory {
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final SocketFactory socketFactory;
    private final BufferProvider bufferProvider = PowerOfTwoBufferPool.DEFAULT;

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings, @Nullable SocketFactory socketFactory) {
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.socketFactory = socketFactory;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        SocketStream stream;
        if (serverAddress instanceof UnixServerAddress) {
            if (this.sslSettings.isEnabled()) {
                throw new MongoClientException("Socket based connections do not support ssl");
            }
            stream = new UnixSocketChannelStream((UnixServerAddress)serverAddress, this.settings, this.sslSettings, this.bufferProvider);
        } else {
            stream = this.socketFactory != null ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.socketFactory, this.bufferProvider) : (this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.getSslContext().getSocketFactory(), this.bufferProvider) : new SocketStream(serverAddress, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider));
        }
        return stream;
    }

    private SSLContext getSslContext() {
        try {
            return Optional.ofNullable(this.sslSettings.getContext()).orElse(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
    }
}

