/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.connection;

import com.dimensionrogue.libs.mongodb.annotations.Immutable;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.TransportSettings;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.netty.handler.ssl.SslContext;

@Immutable
public final class NettyTransportSettings
extends TransportSettings {
    private final EventLoopGroup eventLoopGroup;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final ByteBufAllocator allocator;
    private final SslContext sslContext;

    static Builder builder() {
        return new Builder();
    }

    @Nullable
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Nullable
    public Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    @Nullable
    public ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    @Nullable
    public SslContext getSslContext() {
        return this.sslContext;
    }

    public String toString() {
        return "NettyTransportSettings{eventLoopGroup=" + this.eventLoopGroup + ", socketChannelClass=" + this.socketChannelClass + ", allocator=" + this.allocator + ", sslContext=" + this.sslContext + '}';
    }

    private NettyTransportSettings(Builder builder) {
        this.allocator = builder.allocator;
        this.socketChannelClass = builder.socketChannelClass;
        this.eventLoopGroup = builder.eventLoopGroup;
        this.sslContext = builder.sslContext;
    }

    public static final class Builder {
        private ByteBufAllocator allocator;
        private Class<? extends SocketChannel> socketChannelClass;
        private EventLoopGroup eventLoopGroup;
        private SslContext sslContext;

        private Builder() {
        }

        public Builder allocator(ByteBufAllocator allocator) {
            this.allocator = Assertions.notNull("allocator", allocator);
            return this;
        }

        public Builder socketChannelClass(Class<? extends SocketChannel> socketChannelClass) {
            this.socketChannelClass = Assertions.notNull("socketChannelClass", socketChannelClass);
            return this;
        }

        public Builder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = Assertions.notNull("eventLoopGroup", eventLoopGroup);
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = Assertions.notNull("sslContext", sslContext);
            Assertions.isTrueArgument("sslContext must be client-side", sslContext.isClient());
            Assertions.isTrueArgument("sslContext must use either SslProvider.JDK or SslProvider.OPENSSL TLS/SSL protocol provider", !(sslContext instanceof ReferenceCountedOpenSslClientContext));
            return this;
        }

        public NettyTransportSettings build() {
            return new NettyTransportSettings(this);
        }
    }
}

