/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.model.search;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonDouble;
import com.dimensionrogue.libs.bson.Document;
import com.dimensionrogue.libs.bson.conversions.Bson;
import com.dimensionrogue.libs.mongodb.annotations.Beta;
import com.dimensionrogue.libs.mongodb.annotations.Sealed;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.search.ConstantSearchScore;
import com.dimensionrogue.libs.mongodb.client.model.search.FieldSearchPath;
import com.dimensionrogue.libs.mongodb.client.model.search.FunctionSearchScore;
import com.dimensionrogue.libs.mongodb.client.model.search.PathBoostSearchScore;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchScoreExpression;
import com.dimensionrogue.libs.mongodb.client.model.search.ValueBoostSearchScore;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float value) {
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", Assertions.notNull("value", path).toValue()));
    }

    public static ConstantSearchScore constant(float value) {
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static FunctionSearchScore function(SearchScoreExpression expression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull("expression", expression));
    }

    public static SearchScore of(Bson score) {
        return new SearchConstructibleBsonElement(Assertions.notNull("score", score));
    }
}

