/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.model.search;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.conversions.Bson;
import com.dimensionrogue.libs.mongodb.annotations.Beta;
import com.dimensionrogue.libs.mongodb.annotations.Sealed;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.search.FieldSearchPath;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchConstructibleBson;
import com.dimensionrogue.libs.mongodb.client.model.search.WildcardSearchPath;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchPath
extends Bson {
    public static FieldSearchPath fieldPath(String path) {
        Assertions.notNull("path", path);
        Assertions.isTrueArgument("path must not contain '*'", !path.contains("*"));
        return new SearchConstructibleBson(new BsonDocument("value", new BsonString(path)));
    }

    public static WildcardSearchPath wildcardPath(String wildcardPath) {
        Assertions.notNull("wildcardPath", wildcardPath);
        Assertions.isTrueArgument("wildcardPath must contain '*'", wildcardPath.contains("*"));
        Assertions.isTrueArgument("wildcardPath must not contain '**'", !wildcardPath.contains("**"));
        return new SearchConstructibleBson(new BsonDocument("wildcard", new BsonString(wildcardPath)));
    }

    default public BsonValue toBsonValue() {
        BsonDocument doc = this.toBsonDocument();
        if (doc.size() > 1) {
            return doc;
        }
        BsonString value = doc.getString("value", null);
        if (value != null) {
            return value;
        }
        return doc;
    }
}

