/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.model.search;

import com.dimensionrogue.libs.bson.Document;
import com.dimensionrogue.libs.bson.conversions.Bson;
import com.dimensionrogue.libs.mongodb.annotations.Beta;
import com.dimensionrogue.libs.mongodb.annotations.Sealed;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.geojson.Point;
import com.dimensionrogue.libs.mongodb.client.model.search.AutocompleteSearchOperator;
import com.dimensionrogue.libs.mongodb.client.model.search.CompoundSearchOperatorBase;
import com.dimensionrogue.libs.mongodb.client.model.search.DateNearSearchOperator;
import com.dimensionrogue.libs.mongodb.client.model.search.DateRangeConstructibleBsonElement;
import com.dimensionrogue.libs.mongodb.client.model.search.DateRangeSearchOperatorBase;
import com.dimensionrogue.libs.mongodb.client.model.search.ExistsSearchOperator;
import com.dimensionrogue.libs.mongodb.client.model.search.FieldSearchPath;
import com.dimensionrogue.libs.mongodb.client.model.search.GeoNearSearchOperator;
import com.dimensionrogue.libs.mongodb.client.model.search.NumberNearSearchOperator;
import com.dimensionrogue.libs.mongodb.client.model.search.NumberRangeConstructibleBsonElement;
import com.dimensionrogue.libs.mongodb.client.model.search.NumberRangeSearchOperatorBase;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchPath;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchScore;
import com.dimensionrogue.libs.mongodb.client.model.search.TextSearchOperator;
import com.dimensionrogue.libs.mongodb.internal.Iterables;
import com.dimensionrogue.libs.mongodb.internal.client.model.Util;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchOperator
extends Bson {
    public SearchOperator score(SearchScore var1);

    public static CompoundSearchOperatorBase compound() {
        return new SearchConstructibleBsonElement("compound");
    }

    public static ExistsSearchOperator exists(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("exists", (Bson)new Document("path", Assertions.notNull("path", path).toValue()));
    }

    public static TextSearchOperator text(SearchPath path, String query) {
        return SearchOperator.text(Collections.singleton(Assertions.notNull("path", path)), Collections.singleton(Assertions.notNull("query", query)));
    }

    public static TextSearchOperator text(Iterable<? extends SearchPath> paths, Iterable<String> queries) {
        Iterator<String> queryIterator = Assertions.notNull("queries", queries).iterator();
        Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = queryIterator.next();
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("text", (Bson)new Document("query", queryIterator.hasNext() ? queries : firstQuery).append("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static AutocompleteSearchOperator autocomplete(FieldSearchPath path, String query, String ... queries) {
        return SearchOperator.autocomplete(path, Iterables.concat(Assertions.notNull("query", query), queries));
    }

    public static AutocompleteSearchOperator autocomplete(FieldSearchPath path, Iterable<String> queries) {
        Iterator<String> queryIterator = Assertions.notNull("queries", queries).iterator();
        Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = queryIterator.next();
        return new SearchConstructibleBsonElement("autocomplete", (Bson)new Document("query", queryIterator.hasNext() ? queries : firstQuery).append("path", Assertions.notNull("path", path).toValue()));
    }

    public static NumberRangeSearchOperatorBase numberRange(FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.numberRange(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static NumberRangeSearchOperatorBase numberRange(Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new NumberRangeConstructibleBsonElement("range", (Bson)new Document("path", Util.combineToBsonValue(pathIterator, true)));
    }

    public static DateRangeSearchOperatorBase dateRange(FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.dateRange(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static DateRangeSearchOperatorBase dateRange(Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new DateRangeConstructibleBsonElement("range", (Bson)new Document("path", Util.combineToBsonValue(pathIterator, true)));
    }

    public static NumberNearSearchOperator near(Number origin, Number pivot, FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.near(origin, pivot, Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static NumberNearSearchOperator near(Number origin, Number pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", origin)).append("path", Util.combineToBsonValue(pathIterator, true)).append("pivot", Assertions.notNull("pivot", pivot)));
    }

    public static DateNearSearchOperator near(Instant origin, Duration pivot, FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.near(origin, pivot, Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static DateNearSearchOperator near(Instant origin, Duration pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        Assertions.notNull("pivot", pivot);
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", origin)).append("path", Util.combineToBsonValue(pathIterator, true)).append("pivot", pivot.toMillis()));
    }

    public static GeoNearSearchOperator near(Point origin, Number pivot, FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.near(origin, pivot, Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static GeoNearSearchOperator near(Point origin, Number pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", origin)).append("path", Util.combineToBsonValue(pathIterator, true)).append("pivot", Assertions.notNull("pivot", pivot)));
    }

    public static SearchOperator of(Bson operator) {
        return new SearchConstructibleBsonElement(Assertions.notNull("operator", operator));
    }
}

