/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.model.search;

import com.dimensionrogue.libs.bson.Document;
import com.dimensionrogue.libs.bson.conversions.Bson;
import com.dimensionrogue.libs.mongodb.annotations.Beta;
import com.dimensionrogue.libs.mongodb.annotations.Sealed;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.search.FacetSearchCollector;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchFacet;
import com.dimensionrogue.libs.mongodb.client.model.search.SearchOperator;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchCollector
extends Bson {
    @Beta(value={Beta.Reason.CLIENT, Beta.Reason.SERVER})
    public static FacetSearchCollector facet(SearchOperator operator, Iterable<? extends SearchFacet> facets) {
        Assertions.notNull("operator", operator);
        Assertions.notNull("facets", facets);
        return new SearchConstructibleBsonElement("facet", (Bson)new Document("operator", operator).append("facets", SearchFacet.combineToBson(facets)));
    }

    public static SearchCollector of(Bson collector) {
        return new SearchConstructibleBsonElement(Assertions.notNull("collector", collector));
    }
}

