/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.model.geojson;

import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.EncoderContext;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistries;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.json.JsonWriter;
import com.dimensionrogue.libs.bson.json.JsonWriterSettings;
import com.dimensionrogue.libs.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.dimensionrogue.libs.mongodb.client.model.geojson.GeoJsonObjectType;
import com.dimensionrogue.libs.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.io.StringWriter;
import java.util.Objects;

public abstract class Geometry {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new GeoJsonCodecProvider());
    private final CoordinateReferenceSystem coordinateReferenceSystem;

    protected Geometry() {
        this(null);
    }

    protected Geometry(@Nullable CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    public abstract GeoJsonObjectType getType();

    public String toJson() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter, JsonWriterSettings.builder().build());
        Codec<?> codec = Geometry.getRegistry().get(this.getClass());
        codec.encode(writer, this, EncoderContext.builder().build());
        return stringWriter.toString();
    }

    static CodecRegistry getRegistry() {
        return REGISTRY;
    }

    @Nullable
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Geometry geometry = (Geometry)o;
        return Objects.equals(this.coordinateReferenceSystem, geometry.coordinateReferenceSystem);
    }

    public int hashCode() {
        return this.coordinateReferenceSystem != null ? this.coordinateReferenceSystem.hashCode() : 0;
    }
}

