/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.internal;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.conversions.Bson;
import com.dimensionrogue.libs.mongodb.ReadConcern;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.ClientSession;
import com.dimensionrogue.libs.mongodb.client.ListDatabasesIterable;
import com.dimensionrogue.libs.mongodb.client.internal.MongoIterableImpl;
import com.dimensionrogue.libs.mongodb.client.internal.OperationExecutor;
import com.dimensionrogue.libs.mongodb.internal.operation.BatchCursor;
import com.dimensionrogue.libs.mongodb.internal.operation.ReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.SyncOperations;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public class ListDatabasesIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListDatabasesIterable<TResult> {
    private final SyncOperations<BsonDocument> operations;
    private final Class<TResult> resultClass;
    private long maxTimeMS;
    private Bson filter;
    private Boolean nameOnly;
    private Boolean authorizedDatabasesOnly;
    private BsonValue comment;

    ListDatabasesIterableImpl(@Nullable ClientSession clientSession, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        this(clientSession, resultClass, codecRegistry, readPreference, executor, true);
    }

    public ListDatabasesIterableImpl(@Nullable ClientSession clientSession, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor, boolean retryReads) {
        super(clientSession, executor, ReadConcern.DEFAULT, readPreference, retryReads);
        this.operations = new SyncOperations<BsonDocument>(BsonDocument.class, readPreference, codecRegistry, retryReads);
        this.resultClass = Assertions.notNull("clazz", resultClass);
    }

    @Override
    public ListDatabasesIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> nameOnly(@Nullable Boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> authorizedDatabasesOnly(@Nullable Boolean authorizedDatabasesOnly) {
        this.authorizedDatabasesOnly = authorizedDatabasesOnly;
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public ListDatabasesIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.listDatabases(this.resultClass, this.filter, this.nameOnly, this.maxTimeMS, this.authorizedDatabasesOnly, this.comment);
    }
}

