/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.internal;

import com.dimensionrogue.libs.mongodb.AutoEncryptionSettings;
import com.dimensionrogue.libs.mongodb.ClientEncryptionSettings;
import com.dimensionrogue.libs.mongodb.MongoClientSettings;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.client.MongoClient;
import com.dimensionrogue.libs.mongodb.client.MongoClients;
import com.dimensionrogue.libs.mongodb.client.internal.CollectionInfoRetriever;
import com.dimensionrogue.libs.mongodb.client.internal.CommandMarker;
import com.dimensionrogue.libs.mongodb.client.internal.Crypt;
import com.dimensionrogue.libs.mongodb.client.internal.KeyManagementService;
import com.dimensionrogue.libs.mongodb.client.internal.KeyRetriever;
import com.dimensionrogue.libs.mongodb.client.internal.MongoClientImpl;
import com.dimensionrogue.libs.mongodb.crypt.capi.MongoCrypt;
import com.dimensionrogue.libs.mongodb.crypt.capi.MongoCryptOptions;
import com.dimensionrogue.libs.mongodb.crypt.capi.MongoCrypts;
import com.dimensionrogue.libs.mongodb.internal.capi.MongoCryptHelper;
import java.util.Map;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(MongoClientImpl client, AutoEncryptionSettings settings) {
        MongoClient sharedInternalClient = null;
        MongoClientSettings keyVaultMongoClientSettings = settings.getKeyVaultMongoClientSettings();
        if (keyVaultMongoClientSettings == null || !settings.isBypassAutoEncryption()) {
            MongoClientSettings defaultInternalMongoClientSettings = MongoClientSettings.builder(client.getSettings()).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            sharedInternalClient = MongoClients.create(defaultInternalMongoClientSettings);
        }
        MongoClient keyVaultClient = keyVaultMongoClientSettings == null ? sharedInternalClient : MongoClients.create(keyVaultMongoClientSettings);
        MongoCrypt mongoCrypt = MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings));
        return new Crypt(mongoCrypt, Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers(), settings.isBypassAutoEncryption(), settings.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(sharedInternalClient), new CommandMarker(mongoCrypt, settings), sharedInternalClient, keyVaultClient);
    }

    static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings settings) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings)), Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers());
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap) {
        return new KeyManagementService(kmsProviderSslContextMap, 10000);
    }

    private Crypts() {
    }
}

