/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.internal;

import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.RequestContext;
import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.ServerApi;
import com.dimensionrogue.libs.mongodb.client.internal.Crypt;
import com.dimensionrogue.libs.mongodb.client.internal.CryptConnection;
import com.dimensionrogue.libs.mongodb.connection.ServerDescription;
import com.dimensionrogue.libs.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.ConnectionSource;
import com.dimensionrogue.libs.mongodb.internal.binding.ReadWriteBinding;
import com.dimensionrogue.libs.mongodb.internal.connection.Cluster;
import com.dimensionrogue.libs.mongodb.internal.connection.Connection;
import com.dimensionrogue.libs.mongodb.internal.connection.OperationContext;
import com.dimensionrogue.libs.mongodb.internal.session.SessionContext;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

class CryptBinding
implements ClusterAwareReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    CryptBinding(ClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.crypt = crypt;
        this.wrapped = wrapped;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource());
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference));
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new CryptConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new CryptConnectionSource(this.wrapped.getConnectionSource(serverAddress));
    }

    @Override
    public SessionContext getSessionContext() {
        return this.wrapped.getSessionContext();
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    @Override
    public RequestContext getRequestContext() {
        return this.wrapped.getRequestContext();
    }

    @Override
    public OperationContext getOperationContext() {
        return this.wrapped.getOperationContext();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public int release() {
        return this.wrapped.release();
    }

    @Override
    public Cluster getCluster() {
        return this.wrapped.getCluster();
    }

    private class CryptConnectionSource
    implements ConnectionSource {
        private final ConnectionSource wrapped;

        CryptConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return this.wrapped.getSessionContext();
        }

        @Override
        public OperationContext getOperationContext() {
            return this.wrapped.getOperationContext();
        }

        @Override
        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        @Override
        public RequestContext getRequestContext() {
            return this.wrapped.getRequestContext();
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public Connection getConnection() {
            return new CryptConnection(this.wrapped.getConnection(), CryptBinding.this.crypt);
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public int release() {
            return this.wrapped.release();
        }
    }
}

