/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client.internal;

import com.dimensionrogue.libs.bson.RawBsonDocument;
import com.dimensionrogue.libs.bson.conversions.Bson;
import com.dimensionrogue.libs.mongodb.AutoEncryptionSettings;
import com.dimensionrogue.libs.mongodb.MongoClientException;
import com.dimensionrogue.libs.mongodb.MongoException;
import com.dimensionrogue.libs.mongodb.MongoTimeoutException;
import com.dimensionrogue.libs.mongodb.ReadConcern;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.MongoClient;
import com.dimensionrogue.libs.mongodb.client.MongoClients;
import com.dimensionrogue.libs.mongodb.crypt.capi.MongoCrypt;
import com.dimensionrogue.libs.mongodb.internal.capi.MongoCryptHelper;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Map;

class CommandMarker
implements Closeable {
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled(mongoCrypt.getCryptSharedLibVersionString(), settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map<String, Object> extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = (Boolean)extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(extraOptions);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)extraOptions.get("mongocryptdURI")));
        }
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command) {
        if (this.client != null) {
            try {
                try {
                    return this.executeCommand(databaseName, command);
                }
                catch (MongoTimeoutException e) {
                    if (this.processBuilder == null) {
                        throw e;
                    }
                    MongoCryptHelper.startProcess(this.processBuilder);
                    return this.executeCommand(databaseName, command);
                }
            }
            catch (MongoException e) {
                throw this.wrapInClientException(e);
            }
        }
        return command;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand) {
        Assertions.assertNotNull(this.client);
        return this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

