/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client;

import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.ServerCursor;
import com.dimensionrogue.libs.mongodb.annotations.NotThreadSafe;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Iterator;
import java.util.function.Consumer;

@NotThreadSafe
public interface MongoCursor<TResult>
extends Iterator<TResult>,
Closeable {
    @Override
    public void close();

    @Override
    public boolean hasNext();

    @Override
    public TResult next();

    public int available();

    @Nullable
    public TResult tryNext();

    @Nullable
    public ServerCursor getServerCursor();

    public ServerAddress getServerAddress();

    @Override
    default public void forEachRemaining(Consumer<? super TResult> action) {
        try {
            Iterator.super.forEachRemaining(action);
        }
        finally {
            this.close();
        }
    }
}

