/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.client;

import com.dimensionrogue.libs.bson.Document;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.conversions.Bson;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.ReadConcern;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.WriteConcern;
import com.dimensionrogue.libs.mongodb.annotations.ThreadSafe;
import com.dimensionrogue.libs.mongodb.bulk.BulkWriteResult;
import com.dimensionrogue.libs.mongodb.client.AggregateIterable;
import com.dimensionrogue.libs.mongodb.client.ChangeStreamIterable;
import com.dimensionrogue.libs.mongodb.client.ClientSession;
import com.dimensionrogue.libs.mongodb.client.DistinctIterable;
import com.dimensionrogue.libs.mongodb.client.FindIterable;
import com.dimensionrogue.libs.mongodb.client.ListIndexesIterable;
import com.dimensionrogue.libs.mongodb.client.ListSearchIndexesIterable;
import com.dimensionrogue.libs.mongodb.client.MapReduceIterable;
import com.dimensionrogue.libs.mongodb.client.model.BulkWriteOptions;
import com.dimensionrogue.libs.mongodb.client.model.CountOptions;
import com.dimensionrogue.libs.mongodb.client.model.CreateIndexOptions;
import com.dimensionrogue.libs.mongodb.client.model.DeleteOptions;
import com.dimensionrogue.libs.mongodb.client.model.DropCollectionOptions;
import com.dimensionrogue.libs.mongodb.client.model.DropIndexOptions;
import com.dimensionrogue.libs.mongodb.client.model.EstimatedDocumentCountOptions;
import com.dimensionrogue.libs.mongodb.client.model.FindOneAndDeleteOptions;
import com.dimensionrogue.libs.mongodb.client.model.FindOneAndReplaceOptions;
import com.dimensionrogue.libs.mongodb.client.model.FindOneAndUpdateOptions;
import com.dimensionrogue.libs.mongodb.client.model.IndexModel;
import com.dimensionrogue.libs.mongodb.client.model.IndexOptions;
import com.dimensionrogue.libs.mongodb.client.model.InsertManyOptions;
import com.dimensionrogue.libs.mongodb.client.model.InsertOneOptions;
import com.dimensionrogue.libs.mongodb.client.model.RenameCollectionOptions;
import com.dimensionrogue.libs.mongodb.client.model.ReplaceOptions;
import com.dimensionrogue.libs.mongodb.client.model.SearchIndexModel;
import com.dimensionrogue.libs.mongodb.client.model.UpdateOptions;
import com.dimensionrogue.libs.mongodb.client.model.WriteModel;
import com.dimensionrogue.libs.mongodb.client.result.DeleteResult;
import com.dimensionrogue.libs.mongodb.client.result.InsertManyResult;
import com.dimensionrogue.libs.mongodb.client.result.InsertOneResult;
import com.dimensionrogue.libs.mongodb.client.result.UpdateResult;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.List;

@ThreadSafe
public interface MongoCollection<TDocument> {
    public MongoNamespace getNamespace();

    public Class<TDocument> getDocumentClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<TDocument> withReadPreference(ReadPreference var1);

    public MongoCollection<TDocument> withWriteConcern(WriteConcern var1);

    public MongoCollection<TDocument> withReadConcern(ReadConcern var1);

    public long countDocuments();

    public long countDocuments(Bson var1);

    public long countDocuments(Bson var1, CountOptions var2);

    public long countDocuments(ClientSession var1);

    public long countDocuments(ClientSession var1, Bson var2);

    public long countDocuments(ClientSession var1, Bson var2, CountOptions var3);

    public long estimatedDocumentCount();

    public long estimatedDocumentCount(EstimatedDocumentCountOptions var1);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Class<TResult> var2);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Bson var2, Class<TResult> var3);

    public <TResult> DistinctIterable<TResult> distinct(ClientSession var1, String var2, Class<TResult> var3);

    public <TResult> DistinctIterable<TResult> distinct(ClientSession var1, String var2, Bson var3, Class<TResult> var4);

    public FindIterable<TDocument> find();

    public <TResult> FindIterable<TResult> find(Class<TResult> var1);

    public FindIterable<TDocument> find(Bson var1);

    public <TResult> FindIterable<TResult> find(Bson var1, Class<TResult> var2);

    public FindIterable<TDocument> find(ClientSession var1);

    public <TResult> FindIterable<TResult> find(ClientSession var1, Class<TResult> var2);

    public FindIterable<TDocument> find(ClientSession var1, Bson var2);

    public <TResult> FindIterable<TResult> find(ClientSession var1, Bson var2, Class<TResult> var3);

    public AggregateIterable<TDocument> aggregate(List<? extends Bson> var1);

    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public AggregateIterable<TDocument> aggregate(ClientSession var1, List<? extends Bson> var2);

    public <TResult> AggregateIterable<TResult> aggregate(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public ChangeStreamIterable<TDocument> watch();

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> var1);

    public ChangeStreamIterable<TDocument> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamIterable<TDocument> watch(ClientSession var1);

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamIterable<TDocument> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    @Deprecated
    public MapReduceIterable<TDocument> mapReduce(String var1, String var2);

    @Deprecated
    public <TResult> MapReduceIterable<TResult> mapReduce(String var1, String var2, Class<TResult> var3);

    @Deprecated
    public MapReduceIterable<TDocument> mapReduce(ClientSession var1, String var2, String var3);

    @Deprecated
    public <TResult> MapReduceIterable<TResult> mapReduce(ClientSession var1, String var2, String var3, Class<TResult> var4);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> var1);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, BulkWriteOptions var2);

    public BulkWriteResult bulkWrite(ClientSession var1, List<? extends WriteModel<? extends TDocument>> var2);

    public BulkWriteResult bulkWrite(ClientSession var1, List<? extends WriteModel<? extends TDocument>> var2, BulkWriteOptions var3);

    public InsertOneResult insertOne(TDocument var1);

    public InsertOneResult insertOne(TDocument var1, InsertOneOptions var2);

    public InsertOneResult insertOne(ClientSession var1, TDocument var2);

    public InsertOneResult insertOne(ClientSession var1, TDocument var2, InsertOneOptions var3);

    public InsertManyResult insertMany(List<? extends TDocument> var1);

    public InsertManyResult insertMany(List<? extends TDocument> var1, InsertManyOptions var2);

    public InsertManyResult insertMany(ClientSession var1, List<? extends TDocument> var2);

    public InsertManyResult insertMany(ClientSession var1, List<? extends TDocument> var2, InsertManyOptions var3);

    public DeleteResult deleteOne(Bson var1);

    public DeleteResult deleteOne(Bson var1, DeleteOptions var2);

    public DeleteResult deleteOne(ClientSession var1, Bson var2);

    public DeleteResult deleteOne(ClientSession var1, Bson var2, DeleteOptions var3);

    public DeleteResult deleteMany(Bson var1);

    public DeleteResult deleteMany(Bson var1, DeleteOptions var2);

    public DeleteResult deleteMany(ClientSession var1, Bson var2);

    public DeleteResult deleteMany(ClientSession var1, Bson var2, DeleteOptions var3);

    public UpdateResult replaceOne(Bson var1, TDocument var2);

    public UpdateResult replaceOne(Bson var1, TDocument var2, ReplaceOptions var3);

    public UpdateResult replaceOne(ClientSession var1, Bson var2, TDocument var3);

    public UpdateResult replaceOne(ClientSession var1, Bson var2, TDocument var3, ReplaceOptions var4);

    public UpdateResult updateOne(Bson var1, Bson var2);

    public UpdateResult updateOne(Bson var1, Bson var2, UpdateOptions var3);

    public UpdateResult updateOne(ClientSession var1, Bson var2, Bson var3);

    public UpdateResult updateOne(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4);

    public UpdateResult updateOne(Bson var1, List<? extends Bson> var2);

    public UpdateResult updateOne(Bson var1, List<? extends Bson> var2, UpdateOptions var3);

    public UpdateResult updateOne(ClientSession var1, Bson var2, List<? extends Bson> var3);

    public UpdateResult updateOne(ClientSession var1, Bson var2, List<? extends Bson> var3, UpdateOptions var4);

    public UpdateResult updateMany(Bson var1, Bson var2);

    public UpdateResult updateMany(Bson var1, Bson var2, UpdateOptions var3);

    public UpdateResult updateMany(ClientSession var1, Bson var2, Bson var3);

    public UpdateResult updateMany(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4);

    public UpdateResult updateMany(Bson var1, List<? extends Bson> var2);

    public UpdateResult updateMany(Bson var1, List<? extends Bson> var2, UpdateOptions var3);

    public UpdateResult updateMany(ClientSession var1, Bson var2, List<? extends Bson> var3);

    public UpdateResult updateMany(ClientSession var1, Bson var2, List<? extends Bson> var3, UpdateOptions var4);

    @Nullable
    public TDocument findOneAndDelete(Bson var1);

    @Nullable
    public TDocument findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2);

    @Nullable
    public TDocument findOneAndDelete(ClientSession var1, Bson var2);

    @Nullable
    public TDocument findOneAndDelete(ClientSession var1, Bson var2, FindOneAndDeleteOptions var3);

    @Nullable
    public TDocument findOneAndReplace(Bson var1, TDocument var2);

    @Nullable
    public TDocument findOneAndReplace(Bson var1, TDocument var2, FindOneAndReplaceOptions var3);

    @Nullable
    public TDocument findOneAndReplace(ClientSession var1, Bson var2, TDocument var3);

    @Nullable
    public TDocument findOneAndReplace(ClientSession var1, Bson var2, TDocument var3, FindOneAndReplaceOptions var4);

    @Nullable
    public TDocument findOneAndUpdate(Bson var1, Bson var2);

    @Nullable
    public TDocument findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3);

    @Nullable
    public TDocument findOneAndUpdate(ClientSession var1, Bson var2, Bson var3);

    @Nullable
    public TDocument findOneAndUpdate(ClientSession var1, Bson var2, Bson var3, FindOneAndUpdateOptions var4);

    @Nullable
    public TDocument findOneAndUpdate(Bson var1, List<? extends Bson> var2);

    @Nullable
    public TDocument findOneAndUpdate(Bson var1, List<? extends Bson> var2, FindOneAndUpdateOptions var3);

    @Nullable
    public TDocument findOneAndUpdate(ClientSession var1, Bson var2, List<? extends Bson> var3);

    @Nullable
    public TDocument findOneAndUpdate(ClientSession var1, Bson var2, List<? extends Bson> var3, FindOneAndUpdateOptions var4);

    public void drop();

    public void drop(ClientSession var1);

    public void drop(DropCollectionOptions var1);

    public void drop(ClientSession var1, DropCollectionOptions var2);

    public String createSearchIndex(String var1, Bson var2);

    public String createSearchIndex(Bson var1);

    public List<String> createSearchIndexes(List<SearchIndexModel> var1);

    public void updateSearchIndex(String var1, Bson var2);

    public void dropSearchIndex(String var1);

    public ListSearchIndexesIterable<Document> listSearchIndexes();

    public <TResult> ListSearchIndexesIterable<TResult> listSearchIndexes(Class<TResult> var1);

    public String createIndex(Bson var1);

    public String createIndex(Bson var1, IndexOptions var2);

    public String createIndex(ClientSession var1, Bson var2);

    public String createIndex(ClientSession var1, Bson var2, IndexOptions var3);

    public List<String> createIndexes(List<IndexModel> var1);

    public List<String> createIndexes(List<IndexModel> var1, CreateIndexOptions var2);

    public List<String> createIndexes(ClientSession var1, List<IndexModel> var2);

    public List<String> createIndexes(ClientSession var1, List<IndexModel> var2, CreateIndexOptions var3);

    public ListIndexesIterable<Document> listIndexes();

    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> var1);

    public ListIndexesIterable<Document> listIndexes(ClientSession var1);

    public <TResult> ListIndexesIterable<TResult> listIndexes(ClientSession var1, Class<TResult> var2);

    public void dropIndex(String var1);

    public void dropIndex(String var1, DropIndexOptions var2);

    public void dropIndex(Bson var1);

    public void dropIndex(Bson var1, DropIndexOptions var2);

    public void dropIndex(ClientSession var1, String var2);

    public void dropIndex(ClientSession var1, Bson var2);

    public void dropIndex(ClientSession var1, String var2, DropIndexOptions var3);

    public void dropIndex(ClientSession var1, Bson var2, DropIndexOptions var3);

    public void dropIndexes();

    public void dropIndexes(ClientSession var1);

    public void dropIndexes(DropIndexOptions var1);

    public void dropIndexes(ClientSession var1, DropIndexOptions var2);

    public void renameCollection(MongoNamespace var1);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2);

    public void renameCollection(ClientSession var1, MongoNamespace var2);

    public void renameCollection(ClientSession var1, MongoNamespace var2, RenameCollectionOptions var3);
}

