/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.bulk;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.lang.NonNull;
import java.util.Collections;
import java.util.Set;

public class WriteConcernError {
    private final int code;
    private final String codeName;
    private final String message;
    private final BsonDocument details;
    private final Set<String> errorLabels;

    public WriteConcernError(int code, String codeName, String message, BsonDocument details) {
        this(code, codeName, message, details, Collections.emptySet());
    }

    @Deprecated
    public WriteConcernError(int code, String codeName, String message, BsonDocument details, Set<String> errorLabels) {
        this.code = code;
        this.codeName = Assertions.notNull("codeName", codeName);
        this.message = Assertions.notNull("message", message);
        this.details = Assertions.notNull("details", details);
        this.errorLabels = Assertions.notNull("errorLabels", errorLabels);
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getMessage() {
        return this.message;
    }

    public BsonDocument getDetails() {
        return this.details;
    }

    @Deprecated
    public void addLabel(String errorLabel) {
        Assertions.notNull("errorLabel", errorLabel);
        this.errorLabels.add(errorLabel);
    }

    @NonNull
    @Deprecated
    public Set<String> getErrorLabels() {
        return Collections.unmodifiableSet(this.errorLabels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteConcernError that = (WriteConcernError)o;
        if (this.code != that.code) {
            return false;
        }
        if (!this.codeName.equals(that.codeName)) {
            return false;
        }
        if (!this.details.equals(that.details)) {
            return false;
        }
        if (!this.message.equals(that.message)) {
            return false;
        }
        return this.errorLabels.equals(that.errorLabels);
    }

    public int hashCode() {
        int result = this.code;
        result = 31 * result + this.codeName.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.details.hashCode();
        result = 31 * result + this.errorLabels.hashCode();
        return result;
    }

    public String toString() {
        return "WriteConcernError{code=" + this.code + ", codeName='" + this.codeName + '\'' + ", message='" + this.message + '\'' + ", details=" + this.details + ", errorLabels=" + this.errorLabels + '}';
    }
}

