/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb;

import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.annotations.Immutable;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import jnr.unixsocket.UnixSocketAddress;

@Immutable
public final class UnixServerAddress
extends ServerAddress {
    private static final long serialVersionUID = 154466643544866543L;

    public UnixServerAddress(String path) {
        super(Assertions.notNull("The path cannot be null", path));
        Assertions.isTrueArgument("The path must end in .sock", path.endsWith(".sock"));
    }

    @Override
    @Deprecated
    public InetSocketAddress getSocketAddress() {
        throw new UnsupportedOperationException("Cannot return a InetSocketAddress from a UnixServerAddress");
    }

    @Deprecated
    public SocketAddress getUnixSocketAddress() {
        return new UnixSocketAddress(this.getHost());
    }

    @Override
    public String toString() {
        return this.getHost();
    }
}

