/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb;

import com.dimensionrogue.libs.mongodb.ServerApiVersion;
import com.dimensionrogue.libs.mongodb.annotations.NotThreadSafe;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.Optional;

public final class ServerApi {
    private final ServerApiVersion version;
    private final Boolean deprecationErrors;
    private final Boolean strict;

    private ServerApi(ServerApiVersion version, @Nullable Boolean strict, @Nullable Boolean deprecationErrors) {
        this.version = Assertions.notNull("version", version);
        this.deprecationErrors = deprecationErrors;
        this.strict = strict;
    }

    public ServerApiVersion getVersion() {
        return this.version;
    }

    public Optional<Boolean> getStrict() {
        return Optional.ofNullable(this.strict);
    }

    public Optional<Boolean> getDeprecationErrors() {
        return Optional.ofNullable(this.deprecationErrors);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ServerApi{version=" + (Object)((Object)this.version) + ", deprecationErrors=" + this.deprecationErrors + ", strict=" + this.strict + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerApi serverApi = (ServerApi)o;
        if (this.version != serverApi.version) {
            return false;
        }
        if (!Objects.equals(this.deprecationErrors, serverApi.deprecationErrors)) {
            return false;
        }
        return Objects.equals(this.strict, serverApi.strict);
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = 31 * result + (this.deprecationErrors != null ? this.deprecationErrors.hashCode() : 0);
        result = 31 * result + (this.strict != null ? this.strict.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private ServerApiVersion version;
        private Boolean deprecationErrors;
        private Boolean strict;

        private Builder() {
        }

        public Builder version(ServerApiVersion version) {
            this.version = version;
            return this;
        }

        public Builder deprecationErrors(boolean deprecationErrors) {
            this.deprecationErrors = deprecationErrors;
            return this;
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public ServerApi build() {
            return new ServerApi(this.version, this.strict, this.deprecationErrors);
        }
    }
}

