/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb;

import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecProvider;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.codecs.kotlin.DataClassCodecProvider;
import com.dimensionrogue.libs.bson.codecs.kotlinx.KotlinSerializerCodecProvider;
import com.dimensionrogue.libs.bson.internal.ProvidersCodecRegistry;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class KotlinCodecProvider
implements CodecProvider {
    @Nullable
    private static final CodecProvider KOTLIN_SERIALIZABLE_CODEC_PROVIDER;
    @Nullable
    private static final CodecProvider DATA_CLASS_CODEC_PROVIDER;

    @Override
    @Nullable
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.get(clazz, Collections.emptyList(), registry);
    }

    @Override
    @Nullable
    public <T> Codec<T> get(Class<T> clazz, List<Type> typeArguments, CodecRegistry registry) {
        Codec<T> codec = null;
        if (KOTLIN_SERIALIZABLE_CODEC_PROVIDER != null) {
            codec = ProvidersCodecRegistry.getFromCodecProvider(KOTLIN_SERIALIZABLE_CODEC_PROVIDER, clazz, typeArguments, registry);
        }
        if (codec == null && DATA_CLASS_CODEC_PROVIDER != null) {
            codec = ProvidersCodecRegistry.getFromCodecProvider(DATA_CLASS_CODEC_PROVIDER, clazz, typeArguments, registry);
        }
        return codec;
    }

    static {
        KotlinSerializerCodecProvider possibleCodecProvider = null;
        try {
            Class.forName("com.dimensionrogue.libs.bson.codecs.kotlinx.KotlinSerializerCodecProvider");
            possibleCodecProvider = new KotlinSerializerCodecProvider();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        KOTLIN_SERIALIZABLE_CODEC_PROVIDER = possibleCodecProvider;
        possibleCodecProvider = null;
        try {
            Class.forName("com.dimensionrogue.libs.bson.codecs.kotlin.DataClassCodecProvider");
            possibleCodecProvider = new DataClassCodecProvider();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DATA_CLASS_CODEC_PROVIDER = possibleCodecProvider;
    }
}

