/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb;

import com.dimensionrogue.libs.bson.BsonReader;
import com.dimensionrogue.libs.bson.BsonWriter;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.bson.codecs.EncoderContext;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.mongodb.DBRef;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;

public class DBRefCodec
implements Codec<DBRef> {
    private final CodecRegistry registry;

    public DBRefCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    @Override
    public void encode(BsonWriter writer, DBRef value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString("$ref", value.getCollectionName());
        writer.writeName("$id");
        Codec<?> codec = this.registry.get(value.getId().getClass());
        codec.encode(writer, value.getId(), encoderContext);
        if (value.getDatabaseName() != null) {
            writer.writeString("$db", value.getDatabaseName());
        }
        writer.writeEndDocument();
    }

    @Override
    public Class<DBRef> getEncoderClass() {
        return DBRef.class;
    }

    @Override
    public DBRef decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("DBRefCodec does not support decoding");
    }
}

