/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb;

import com.dimensionrogue.libs.bson.codecs.BsonTypeClassMap;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.DateCodec;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecProvider;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.types.BSONTimestamp;
import com.dimensionrogue.libs.mongodb.BSONTimestampCodec;
import com.dimensionrogue.libs.mongodb.DBObject;
import com.dimensionrogue.libs.mongodb.DBObjectCodec;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import java.util.Date;
import java.util.List;

public class DBObjectCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;

    public DBObjectCodecProvider() {
        this(DBObjectCodec.getDefaultBsonTypeClassMap());
    }

    public DBObjectCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == BSONTimestamp.class) {
            return new BSONTimestampCodec();
        }
        if (DBObject.class.isAssignableFrom(clazz) && !List.class.isAssignableFrom(clazz)) {
            return new DBObjectCodec(registry, this.bsonTypeClassMap);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DateCodec();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "DBObjectCodecProvider{}";
    }
}

