/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.internal;

import com.dimensionrogue.libs.bson.BsonReader;
import com.dimensionrogue.libs.bson.BsonWriter;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.bson.codecs.EncoderContext;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import java.lang.reflect.Type;
import java.util.List;

class LazyCodec<T>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> clazz;
    private final List<Type> types;
    private volatile Codec<T> wrapped;

    LazyCodec(CodecRegistry registry, Class<T> clazz, List<Type> types) {
        this.registry = registry;
        this.clazz = clazz;
        this.types = types;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.getWrapped().encode(writer, value, encoderContext);
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return this.getWrapped().decode(reader, decoderContext);
    }

    private Codec<T> getWrapped() {
        if (this.wrapped == null) {
            this.wrapped = this.types == null ? this.registry.get(this.clazz) : this.registry.get(this.clazz, this.types);
        }
        return this.wrapped;
    }
}

