/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs.pojo;

import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.EnumCodec;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecConfigurationException;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.codecs.pojo.PropertyCodecProvider;
import com.dimensionrogue.libs.bson.codecs.pojo.PropertyCodecRegistry;
import com.dimensionrogue.libs.bson.codecs.pojo.TypeWithTypeParameters;

final class EnumPropertyCodecProvider
implements PropertyCodecProvider {
    private final CodecRegistry codecRegistry;

    EnumPropertyCodecProvider(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    @Override
    public <T> Codec<T> get(TypeWithTypeParameters<T> type, PropertyCodecRegistry propertyCodecRegistry) {
        Class<T> clazz = type.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            try {
                return this.codecRegistry.get(clazz);
            }
            catch (CodecConfigurationException e) {
                return new EnumCodec<T>(clazz);
            }
        }
        return null;
    }
}

