/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs.jsr310;

import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecProvider;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.codecs.jsr310.InstantCodec;
import com.dimensionrogue.libs.bson.codecs.jsr310.LocalDateCodec;
import com.dimensionrogue.libs.bson.codecs.jsr310.LocalDateTimeCodec;
import com.dimensionrogue.libs.bson.codecs.jsr310.LocalTimeCodec;
import java.util.HashMap;
import java.util.Map;

public class Jsr310CodecProvider
implements CodecProvider {
    private static final Map<Class<?>, Codec<?>> JSR310_CODEC_MAP = new HashMap();

    private static void putCodec(Codec<?> codec) {
        JSR310_CODEC_MAP.put(codec.getEncoderClass(), codec);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return JSR310_CODEC_MAP.get(clazz);
    }

    public String toString() {
        return "Jsr310CodecProvider{}";
    }

    static {
        Jsr310CodecProvider.putCodec(new InstantCodec());
        Jsr310CodecProvider.putCodec(new LocalDateCodec());
        Jsr310CodecProvider.putCodec(new LocalDateTimeCodec());
        Jsr310CodecProvider.putCodec(new LocalTimeCodec());
    }
}

