/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs.configuration;

import com.dimensionrogue.libs.bson.UuidRepresentation;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecProvider;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.bson.codecs.configuration.MapOfCodecsProvider;
import com.dimensionrogue.libs.bson.codecs.configuration.OverridableUuidRepresentationCodecProvider;
import com.dimensionrogue.libs.bson.internal.ProvidersCodecRegistry;
import java.util.Arrays;
import java.util.List;

public final class CodecRegistries {
    public static CodecRegistry withUuidRepresentation(CodecRegistry codecRegistry, UuidRepresentation uuidRepresentation) {
        return CodecRegistries.fromProviders(new OverridableUuidRepresentationCodecProvider(codecRegistry, uuidRepresentation));
    }

    public static CodecRegistry fromCodecs(Codec<?> ... codecs) {
        return CodecRegistries.fromCodecs(Arrays.asList(codecs));
    }

    public static CodecRegistry fromCodecs(List<? extends Codec<?>> codecs) {
        return CodecRegistries.fromProviders(new MapOfCodecsProvider(codecs));
    }

    public static CodecRegistry fromProviders(CodecProvider ... providers) {
        return CodecRegistries.fromProviders(Arrays.asList(providers));
    }

    public static CodecRegistry fromProviders(List<? extends CodecProvider> providers) {
        return new ProvidersCodecRegistry(providers);
    }

    public static CodecRegistry fromRegistries(CodecRegistry ... registries) {
        return CodecRegistries.fromRegistries(Arrays.asList(registries));
    }

    public static CodecRegistry fromRegistries(List<? extends CodecRegistry> registries) {
        return new ProvidersCodecRegistry(registries);
    }

    private CodecRegistries() {
    }
}

