/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.bson.codecs;

import com.dimensionrogue.libs.bson.BsonBinaryReader;
import com.dimensionrogue.libs.bson.BsonBinaryWriter;
import com.dimensionrogue.libs.bson.BsonReader;
import com.dimensionrogue.libs.bson.BsonWriter;
import com.dimensionrogue.libs.bson.RawBsonDocument;
import com.dimensionrogue.libs.bson.codecs.Codec;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.bson.codecs.EncoderContext;
import com.dimensionrogue.libs.bson.io.BasicOutputBuffer;
import com.dimensionrogue.libs.bson.io.ByteBufferBsonInput;

public class RawBsonDocumentCodec
implements Codec<RawBsonDocument> {
    @Override
    public void encode(BsonWriter writer, RawBsonDocument value, EncoderContext encoderContext) {
        try (BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(value.getByteBuffer()));){
            writer.pipe(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawBsonDocument decode(BsonReader reader, DecoderContext decoderContext) {
        BasicOutputBuffer buffer = new BasicOutputBuffer(0);
        BsonBinaryWriter writer = new BsonBinaryWriter(buffer);
        try {
            writer.pipe(reader);
            RawBsonDocument rawBsonDocument = new RawBsonDocument(buffer.getInternalBuffer(), 0, buffer.getPosition());
            return rawBsonDocument;
        }
        finally {
            writer.close();
            buffer.close();
        }
    }

    @Override
    public Class<RawBsonDocument> getEncoderClass() {
        return RawBsonDocument.class;
    }
}

